/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.shadow.com.univocity.parsers.common;

import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class StringCache<T> {
    private static final int DEFAULT_SIZE_LIMIT = 16384;
    private static final int DEFAULT_MAX_STRING_LENGTH = 0;
    private final Map<String, SoftReference<T>> stringCache = new ConcurrentHashMap<String, SoftReference<T>>();
    private int sizeLimit = 16384;
    private int maxStringLength = 0;

    protected abstract T process(String var1);

    public boolean containsKey(String input2) {
        return this.stringCache.containsKey(input2);
    }

    public int getSizeLimit() {
        return this.sizeLimit;
    }

    public void setSizeLimit(int sizeLimit) {
        if (sizeLimit <= 0) {
            sizeLimit = 16384;
        }
        this.sizeLimit = sizeLimit;
    }

    public void put(String input2, T value) {
        if (input2 == null || input2.length() > this.maxStringLength) {
            return;
        }
        if (this.stringCache.size() >= this.sizeLimit) {
            this.stringCache.clear();
        }
        this.stringCache.put(input2, new SoftReference<T>(value));
    }

    public T get(String input2) {
        T out2;
        if (input2 == null || this.maxStringLength > 0 && input2.length() > this.maxStringLength) {
            return null;
        }
        SoftReference<T> ref = this.stringCache.get(input2);
        if (ref == null || ref.get() == null) {
            out2 = this.process(input2);
            ref = new SoftReference<T>(out2);
            this.stringCache.put(input2, ref);
        } else {
            out2 = ref.get();
        }
        return out2;
    }

    public void clear() {
        this.stringCache.clear();
    }

    public int getMaxStringLength() {
        return this.maxStringLength;
    }

    public void setMaxStringLength(int maxStringLength) {
        this.maxStringLength = maxStringLength;
    }
}

