/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.shadow.com.univocity.parsers.annotations.helpers;

import java.lang.reflect.Method;
import org.junit.jupiter.params.shadow.com.univocity.parsers.annotations.helpers.MethodDescriptor;

public enum MethodFilter {
    ONLY_GETTERS(new Filter(){

        @Override
        public boolean reject(Method method2) {
            return method2.getReturnType() == Void.TYPE || method2.getParameterTypes().length != 0;
        }
    }),
    ONLY_SETTERS(new Filter(){

        @Override
        public boolean reject(Method method2) {
            return method2.getParameterTypes().length != 1;
        }
    });

    private Filter filter;

    private MethodFilter(Filter filter2) {
        this.filter = filter2;
    }

    public boolean reject(Method method2) {
        return this.filter.reject(method2);
    }

    public MethodDescriptor toDescriptor(String prefix, Method method2) {
        if (this.reject(method2)) {
            return null;
        }
        if (this == ONLY_SETTERS) {
            return MethodDescriptor.setter(prefix, method2);
        }
        return MethodDescriptor.getter(prefix, method2);
    }

    private static interface Filter {
        public boolean reject(Method var1);
    }
}

