/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.shadow.com.univocity.parsers.annotations.helpers;

import java.lang.reflect.Method;

public final class MethodDescriptor {
    private final String prefixedName;
    private final String name;
    private final String prefix;
    private final Class<?> parameterType;
    private final Class<?> returnType;
    private final String string;

    private MethodDescriptor(String name, Class<?> parameterType, Class<?> returnType) {
        this.prefixedName = name;
        int lastDot = name.lastIndexOf(46);
        if (lastDot == -1) {
            this.name = name;
            this.prefix = "";
        } else {
            this.name = name.substring(lastDot + 1);
            this.prefix = name.substring(0, lastDot);
        }
        this.parameterType = parameterType;
        this.returnType = returnType;
        this.string = this.generateString();
    }

    private MethodDescriptor(String prefix, String name, Class<?> parameterType, Class<?> returnType) {
        this.prefixedName = prefix + '.' + name;
        this.name = name;
        this.prefix = prefix;
        this.parameterType = parameterType;
        this.returnType = returnType;
        this.string = this.generateString();
    }

    private String generateString() {
        StringBuilder out2 = new StringBuilder("method ");
        if (this.returnType != null) {
            out2.append(this.returnType.getName());
            out2.append(' ');
        }
        if (this.prefix.isEmpty()) {
            out2.append(this.name);
        } else {
            out2.append(this.prefix);
            out2.append('.');
            out2.append(this.name);
        }
        if (this.parameterType != null) {
            out2.append('(');
            out2.append(this.parameterType.getName());
            out2.append(')');
        } else {
            out2.append("()");
        }
        return out2.toString();
    }

    public static MethodDescriptor setter(String name, Class<?> parameterType) {
        return new MethodDescriptor(name, parameterType, null);
    }

    public static MethodDescriptor getter(String name, Class<?> returnType) {
        return new MethodDescriptor(name, null, returnType);
    }

    static MethodDescriptor setter(String prefix, Method method2) {
        return new MethodDescriptor(prefix, method2.getName(), method2.getParameterTypes()[0], null);
    }

    static MethodDescriptor getter(String prefix, Method method2) {
        return new MethodDescriptor(prefix, method2.getName(), null, method2.getReturnType());
    }

    public String getName() {
        return this.name;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public Class<?> getParameterType() {
        return this.parameterType;
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public String getPrefixedName() {
        return this.prefixedName;
    }

    public String toString() {
        return this.string;
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return this.string.equals(o.toString());
    }

    public int hashCode() {
        return this.string.hashCode();
    }
}

