/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.shadow.com.univocity.parsers.annotations.helpers;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;

public class AnnotationRegistry {
    private static final Map<AnnotatedElement, FieldAnnotations> modifiedAnnotations = new HashMap<AnnotatedElement, FieldAnnotations>();

    static final synchronized void setValue(AnnotatedElement annotatedElement, Annotation annotation, String attribute, Object newValue) {
        FieldAnnotations attributes2 = modifiedAnnotations.get(annotatedElement);
        if (attributes2 == null) {
            attributes2 = new FieldAnnotations();
            modifiedAnnotations.put(annotatedElement, attributes2);
        }
        attributes2.setValue(annotation, attribute, newValue);
    }

    public static final synchronized <T> T getValue(AnnotatedElement annotatedElement, Annotation annotation, String attribute, T valueIfNull) {
        if (annotatedElement == null) {
            return valueIfNull;
        }
        Object value = AnnotationRegistry.getValue(annotatedElement, annotation, attribute);
        if (value == null) {
            return valueIfNull;
        }
        return (T)value;
    }

    static final synchronized Object getValue(AnnotatedElement annotatedElement, Annotation annotation, String attribute) {
        FieldAnnotations attributes2 = modifiedAnnotations.get(annotatedElement);
        if (attributes2 == null) {
            return null;
        }
        return attributes2.getValue(annotation, attribute);
    }

    public static final void reset() {
        modifiedAnnotations.clear();
    }

    private static class AnnotationAttributes {
        private Map<String, Object> attributes = new HashMap<String, Object>();

        private AnnotationAttributes() {
        }

        private void setAttribute(String attribute, Object newValue) {
            if (!this.attributes.containsKey(attribute)) {
                this.attributes.put(attribute, newValue);
            } else {
                Class<?> newClass;
                Object existingValue = this.attributes.get(attribute);
                if (existingValue == null || newValue == null) {
                    return;
                }
                Class<?> originalClass = existingValue.getClass();
                if (originalClass != (newClass = newValue.getClass()) && newClass.isArray() && newClass.getComponentType() == existingValue.getClass()) {
                    Object array = Array.newInstance(originalClass, 1);
                    Array.set(array, 0, existingValue);
                    this.attributes.put(attribute, array);
                }
            }
        }

        private Object getAttribute(String attribute) {
            return this.attributes.get(attribute);
        }
    }

    private static class FieldAnnotations {
        private Map<Annotation, AnnotationAttributes> annotations = new HashMap<Annotation, AnnotationAttributes>();

        private FieldAnnotations() {
        }

        private void setValue(Annotation annotation, String attribute, Object newValue) {
            AnnotationAttributes attributes2 = this.annotations.get(annotation);
            if (attributes2 == null) {
                attributes2 = new AnnotationAttributes();
                this.annotations.put(annotation, attributes2);
            }
            attributes2.setAttribute(attribute, newValue);
        }

        private Object getValue(Annotation annotation, String attribute) {
            AnnotationAttributes attributes2 = this.annotations.get(annotation);
            if (attributes2 == null) {
                return null;
            }
            return attributes2.getAttribute(attribute);
        }
    }
}

