/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.converter;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import org.junit.jupiter.params.converter.DefaultArgumentConverter;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;

class FallbackStringToObjectConverter
implements DefaultArgumentConverter.StringToObjectConverter {
    private static final Function<String, Object> NULL_EXECUTABLE = source2 -> source2;
    private static final ConcurrentHashMap<Class<?>, Function<String, Object>> factoryExecutableCache = new ConcurrentHashMap(64);

    FallbackStringToObjectConverter() {
    }

    @Override
    public boolean canConvert(Class<?> targetType) {
        return FallbackStringToObjectConverter.findFactoryExecutable(targetType) != NULL_EXECUTABLE;
    }

    @Override
    public Object convert(String source2, Class<?> targetType) throws Exception {
        Function<String, Object> executable = FallbackStringToObjectConverter.findFactoryExecutable(targetType);
        Preconditions.condition(executable != NULL_EXECUTABLE, "Illegal state: convert() must not be called if canConvert() returned false");
        return executable.apply(source2);
    }

    private static Function<String, Object> findFactoryExecutable(Class<?> targetType) {
        return factoryExecutableCache.computeIfAbsent(targetType, type2 -> {
            Method factoryMethod = FallbackStringToObjectConverter.findFactoryMethod(type2);
            if (factoryMethod != null) {
                return source2 -> ReflectionUtils.invokeMethod(factoryMethod, null, source2);
            }
            Constructor<?> constructor = FallbackStringToObjectConverter.findFactoryConstructor(type2);
            if (constructor != null) {
                return source2 -> ReflectionUtils.newInstance(constructor, source2);
            }
            return NULL_EXECUTABLE;
        });
    }

    private static Method findFactoryMethod(Class<?> targetType) {
        List<Method> factoryMethods = ReflectionUtils.findMethods(targetType, new IsFactoryMethod(targetType), ReflectionUtils.HierarchyTraversalMode.BOTTOM_UP);
        if (factoryMethods.size() == 1) {
            return factoryMethods.get(0);
        }
        return null;
    }

    private static Constructor<?> findFactoryConstructor(Class<?> targetType) {
        List<Constructor<?>> constructors2 = ReflectionUtils.findConstructors(targetType, new IsFactoryConstructor(targetType));
        if (constructors2.size() == 1) {
            return constructors2.get(0);
        }
        return null;
    }

    private static boolean isNotPrivateAndAcceptsSingleStringArgument(Executable executable) {
        return ReflectionUtils.isNotPrivate(executable) && executable.getParameterCount() == 1 && executable.getParameterTypes()[0] == String.class;
    }

    static class IsFactoryMethod
    implements Predicate<Method> {
        private final Class<?> targetType;

        IsFactoryMethod(Class<?> targetType) {
            this.targetType = targetType;
        }

        @Override
        public boolean test(Method method2) {
            if (!method2.getReturnType().equals(this.targetType)) {
                return false;
            }
            if (ReflectionUtils.isNotStatic(method2)) {
                return false;
            }
            return FallbackStringToObjectConverter.isNotPrivateAndAcceptsSingleStringArgument(method2);
        }
    }

    static class IsFactoryConstructor
    implements Predicate<Constructor<?>> {
        private final Class<?> targetType;

        IsFactoryConstructor(Class<?> targetType) {
            this.targetType = targetType;
        }

        @Override
        public boolean test(Constructor<?> constructor) {
            if (!constructor.getDeclaringClass().equals(this.targetType)) {
                return false;
            }
            return FallbackStringToObjectConverter.isNotPrivateAndAcceptsSingleStringArgument(constructor);
        }
    }
}

