/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params;

import java.text.Format;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.jupiter.api.Named;
import org.junit.jupiter.params.ParameterizedTestMethodContext;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.StringUtils;

class ParameterizedTestNameFormatter {
    private static final char ELLIPSIS = '\u2026';
    private final String pattern;
    private final String displayName;
    private final ParameterizedTestMethodContext methodContext;
    private final int argumentMaxLength;

    ParameterizedTestNameFormatter(String pattern, String displayName, ParameterizedTestMethodContext methodContext, int argumentMaxLength) {
        this.pattern = pattern;
        this.displayName = displayName;
        this.methodContext = methodContext;
        this.argumentMaxLength = argumentMaxLength;
    }

    String format(int invocationIndex, Object ... arguments2) {
        try {
            return this.formatSafely(invocationIndex, arguments2);
        }
        catch (Exception ex) {
            String message2 = "The display name pattern defined for the parameterized test is invalid. See nested exception for further details.";
            throw new JUnitException(message2, ex);
        }
    }

    private String formatSafely(int invocationIndex, Object[] arguments2) {
        Object[] namedArguments = this.extractNamedArguments(arguments2);
        String pattern = this.prepareMessageFormatPattern(invocationIndex, namedArguments);
        MessageFormat format = new MessageFormat(pattern);
        Object[] humanReadableArguments = this.makeReadable(format, namedArguments);
        return format.format(humanReadableArguments);
    }

    private Object[] extractNamedArguments(Object[] arguments2) {
        return Arrays.stream(arguments2).map(argument -> argument instanceof Named ? ((Named)argument).getName() : argument).toArray();
    }

    private String prepareMessageFormatPattern(int invocationIndex, Object[] arguments2) {
        String result2 = this.pattern.replace("{displayName}", this.displayName).replace("{index}", String.valueOf(invocationIndex));
        if (result2.contains("{argumentsWithNames}")) {
            result2 = result2.replace("{argumentsWithNames}", this.argumentsWithNamesPattern(arguments2));
        }
        if (result2.contains("{arguments}")) {
            result2 = result2.replace("{arguments}", this.argumentsPattern(arguments2));
        }
        return result2;
    }

    private String argumentsWithNamesPattern(Object[] arguments2) {
        return IntStream.range(0, arguments2.length).mapToObj(index -> this.methodContext.getParameterName(index).map(name -> name + "=").orElse("") + "{" + index + "}").collect(Collectors.joining(", "));
    }

    private String argumentsPattern(Object[] arguments2) {
        return IntStream.range(0, arguments2.length).mapToObj(index -> "{" + index + "}").collect(Collectors.joining(", "));
    }

    private Object[] makeReadable(MessageFormat format, Object[] arguments2) {
        Format[] formats = format.getFormatsByArgumentIndex();
        Object[] result2 = Arrays.copyOf(arguments2, Math.min(arguments2.length, formats.length), Object[].class);
        for (int i2 = 0; i2 < result2.length; ++i2) {
            if (formats[i2] != null) continue;
            result2[i2] = this.truncateIfExceedsMaxLength(StringUtils.nullSafeToString(arguments2[i2]));
        }
        return result2;
    }

    private String truncateIfExceedsMaxLength(String argument) {
        if (argument != null && argument.length() > this.argumentMaxLength) {
            return argument.substring(0, this.argumentMaxLength - 1) + '\u2026';
        }
        return argument;
    }
}

