/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.execution;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;
import org.junit.jupiter.engine.execution.ConstructorInvocation;
import org.junit.jupiter.engine.execution.DefaultParameterContext;
import org.junit.jupiter.engine.execution.InvocationInterceptorChain;
import org.junit.jupiter.engine.execution.MethodInvocation;
import org.junit.jupiter.engine.extension.ExtensionRegistry;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.commons.util.StringUtils;
import org.junit.platform.commons.util.UnrecoverableExceptions;

@API(status=API.Status.INTERNAL, since="5.0")
public class ExecutableInvoker {
    private static final Logger logger = LoggerFactory.getLogger(ExecutableInvoker.class);
    private static final InvocationInterceptorChain interceptorChain = new InvocationInterceptorChain();

    public <T> T invoke(Constructor<T> constructor, Optional<Object> outerInstance, ExtensionContext extensionContext, ExtensionRegistry extensionRegistry, ReflectiveInterceptorCall<Constructor<T>, T> interceptorCall) {
        Object[] arguments2 = this.resolveParameters(constructor, Optional.empty(), outerInstance, extensionContext, extensionRegistry);
        ConstructorInvocation<T> invocation2 = new ConstructorInvocation<T>(constructor, arguments2);
        return this.invoke(invocation2, invocation2, extensionContext, extensionRegistry, interceptorCall);
    }

    public <T> T invoke(Method method2, Object target, ExtensionContext extensionContext, ExtensionRegistry extensionRegistry, ReflectiveInterceptorCall<Method, T> interceptorCall) {
        Optional<Object> optionalTarget = target instanceof Optional ? (Optional<Object>)target : Optional.ofNullable(target);
        Object[] arguments2 = this.resolveParameters(method2, optionalTarget, extensionContext, extensionRegistry);
        MethodInvocation invocation2 = new MethodInvocation(method2, optionalTarget, arguments2);
        return this.invoke(invocation2, invocation2, extensionContext, extensionRegistry, interceptorCall);
    }

    private <E extends Executable, T> T invoke(InvocationInterceptor.Invocation<T> originalInvocation, ReflectiveInvocationContext<E> invocationContext, ExtensionContext extensionContext, ExtensionRegistry extensionRegistry, ReflectiveInterceptorCall<E, T> call2) {
        return (T)interceptorChain.invoke(originalInvocation, extensionRegistry, (interceptor, wrappedInvocation) -> call2.apply(interceptor, wrappedInvocation, invocationContext, extensionContext));
    }

    private Object[] resolveParameters(Method method2, Optional<Object> target, ExtensionContext extensionContext, ExtensionRegistry extensionRegistry) {
        return this.resolveParameters(method2, target, Optional.empty(), extensionContext, extensionRegistry);
    }

    private Object[] resolveParameters(Executable executable, Optional<Object> target, Optional<Object> outerInstance, ExtensionContext extensionContext, ExtensionRegistry extensionRegistry) {
        Preconditions.notNull(target, "target must not be null");
        Parameter[] parameters2 = executable.getParameters();
        Object[] values2 = new Object[parameters2.length];
        int start2 = 0;
        if (outerInstance.isPresent()) {
            values2[0] = outerInstance.get();
            start2 = 1;
        }
        for (int i2 = start2; i2 < parameters2.length; ++i2) {
            DefaultParameterContext parameterContext = new DefaultParameterContext(parameters2[i2], i2, target);
            values2[i2] = this.resolveParameter(parameterContext, executable, extensionContext, extensionRegistry);
        }
        return values2;
    }

    private Object resolveParameter(ParameterContext parameterContext, Executable executable, ExtensionContext extensionContext, ExtensionRegistry extensionRegistry) {
        try {
            List matchingResolvers = extensionRegistry.stream(ParameterResolver.class).filter(resolver -> resolver.supportsParameter(parameterContext, extensionContext)).collect(Collectors.toList());
            if (matchingResolvers.isEmpty()) {
                throw new ParameterResolutionException(String.format("No ParameterResolver registered for parameter [%s] in %s [%s].", parameterContext.getParameter(), ExecutableInvoker.asLabel(executable), executable.toGenericString()));
            }
            if (matchingResolvers.size() > 1) {
                String resolvers = matchingResolvers.stream().map(StringUtils::defaultToString).collect(Collectors.joining(", "));
                throw new ParameterResolutionException(String.format("Discovered multiple competing ParameterResolvers for parameter [%s] in %s [%s]: %s", parameterContext.getParameter(), ExecutableInvoker.asLabel(executable), executable.toGenericString(), resolvers));
            }
            ParameterResolver resolver2 = (ParameterResolver)matchingResolvers.get(0);
            Object value = resolver2.resolveParameter(parameterContext, extensionContext);
            this.validateResolvedType(parameterContext.getParameter(), value, executable, resolver2);
            logger.trace(() -> String.format("ParameterResolver [%s] resolved a value of type [%s] for parameter [%s] in %s [%s].", resolver2.getClass().getName(), value != null ? value.getClass().getName() : null, parameterContext.getParameter(), ExecutableInvoker.asLabel(executable), executable.toGenericString()));
            return value;
        }
        catch (ParameterResolutionException ex) {
            throw ex;
        }
        catch (Throwable throwable) {
            UnrecoverableExceptions.rethrowIfUnrecoverable(throwable);
            String message2 = String.format("Failed to resolve parameter [%s] in %s [%s]", parameterContext.getParameter(), ExecutableInvoker.asLabel(executable), executable.toGenericString());
            if (StringUtils.isNotBlank(throwable.getMessage())) {
                message2 = message2 + ": " + throwable.getMessage();
            }
            throw new ParameterResolutionException(message2, throwable);
        }
    }

    private void validateResolvedType(Parameter parameter, Object value, Executable executable, ParameterResolver resolver) {
        Class<?> type2 = parameter.getType();
        if (!ReflectionUtils.isAssignableTo(value, type2)) {
            String message2 = value == null && type2.isPrimitive() ? String.format("ParameterResolver [%s] resolved a null value for parameter [%s] in %s [%s], but a primitive of type [%s] is required.", resolver.getClass().getName(), parameter, ExecutableInvoker.asLabel(executable), executable.toGenericString(), type2.getName()) : String.format("ParameterResolver [%s] resolved a value of type [%s] for parameter [%s] in %s [%s], but a value assignment compatible with [%s] is required.", resolver.getClass().getName(), value != null ? value.getClass().getName() : null, parameter, ExecutableInvoker.asLabel(executable), executable.toGenericString(), type2.getName());
            throw new ParameterResolutionException(message2);
        }
    }

    private static String asLabel(Executable executable) {
        return executable instanceof Constructor ? "constructor" : "method";
    }

    public static interface ReflectiveInterceptorCall<E extends Executable, T> {
        public T apply(InvocationInterceptor var1, InvocationInterceptor.Invocation<T> var2, ReflectiveInvocationContext<E> var3, ExtensionContext var4) throws Throwable;

        public static ReflectiveInterceptorCall<Method, Void> ofVoidMethod(VoidMethodInterceptorCall call2) {
            return (interceptorChain, invocation2, invocationContext, extensionContext) -> {
                call2.apply(interceptorChain, invocation2, invocationContext, extensionContext);
                return null;
            };
        }

        public static interface VoidMethodInterceptorCall {
            public void apply(InvocationInterceptor var1, InvocationInterceptor.Invocation<Void> var2, ReflectiveInvocationContext<Method> var3, ExtensionContext var4) throws Throwable;
        }
    }
}

