/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.ReflectionUtils;

final class LifecycleMethodUtils {
    private LifecycleMethodUtils() {
    }

    static List<Method> findBeforeAllMethods(Class<?> testClass, boolean requireStatic) {
        return LifecycleMethodUtils.findMethodsAndAssertStatic(testClass, requireStatic, BeforeAll.class, ReflectionUtils.HierarchyTraversalMode.TOP_DOWN);
    }

    static List<Method> findAfterAllMethods(Class<?> testClass, boolean requireStatic) {
        return LifecycleMethodUtils.findMethodsAndAssertStatic(testClass, requireStatic, AfterAll.class, ReflectionUtils.HierarchyTraversalMode.BOTTOM_UP);
    }

    static List<Method> findBeforeEachMethods(Class<?> testClass) {
        return LifecycleMethodUtils.findMethodsAndAssertNonStatic(testClass, BeforeEach.class, ReflectionUtils.HierarchyTraversalMode.TOP_DOWN);
    }

    static List<Method> findAfterEachMethods(Class<?> testClass) {
        return LifecycleMethodUtils.findMethodsAndAssertNonStatic(testClass, AfterEach.class, ReflectionUtils.HierarchyTraversalMode.BOTTOM_UP);
    }

    private static void assertStatic(Class<? extends Annotation> annotationType, Method method2) {
        if (ReflectionUtils.isNotStatic(method2)) {
            throw new JUnitException(String.format("@%s method '%s' must be static unless the test class is annotated with @TestInstance(Lifecycle.PER_CLASS).", annotationType.getSimpleName(), method2.toGenericString()));
        }
    }

    private static void assertNonStatic(Class<? extends Annotation> annotationType, Method method2) {
        if (ReflectionUtils.isStatic(method2)) {
            throw new JUnitException(String.format("@%s method '%s' must not be static.", annotationType.getSimpleName(), method2.toGenericString()));
        }
    }

    private static void assertVoid(Class<? extends Annotation> annotationType, Method method2) {
        if (!ReflectionUtils.returnsVoid(method2)) {
            throw new JUnitException(String.format("@%s method '%s' must not return a value.", annotationType.getSimpleName(), method2.toGenericString()));
        }
    }

    private static List<Method> findMethodsAndAssertStatic(Class<?> testClass, boolean requireStatic, Class<? extends Annotation> annotationType, ReflectionUtils.HierarchyTraversalMode traversalMode) {
        List<Method> methods2 = LifecycleMethodUtils.findMethodsAndCheckVoidReturnType(testClass, annotationType, traversalMode);
        if (requireStatic) {
            methods2.forEach(method2 -> LifecycleMethodUtils.assertStatic(annotationType, method2));
        }
        return methods2;
    }

    private static List<Method> findMethodsAndAssertNonStatic(Class<?> testClass, Class<? extends Annotation> annotationType, ReflectionUtils.HierarchyTraversalMode traversalMode) {
        List<Method> methods2 = LifecycleMethodUtils.findMethodsAndCheckVoidReturnType(testClass, annotationType, traversalMode);
        methods2.forEach(method2 -> LifecycleMethodUtils.assertNonStatic(annotationType, method2));
        return methods2;
    }

    private static List<Method> findMethodsAndCheckVoidReturnType(Class<?> testClass, Class<? extends Annotation> annotationType, ReflectionUtils.HierarchyTraversalMode traversalMode) {
        List<Method> methods2 = AnnotationUtils.findAnnotatedMethods(testClass, annotationType, traversalMode);
        methods2.forEach(method2 -> LifecycleMethodUtils.assertVoid(annotationType, method2));
        return methods2;
    }
}

