/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api.condition;

import java.util.Arrays;
import org.junit.jupiter.api.condition.BooleanExecutionCondition;
import org.junit.jupiter.api.condition.EnabledOnOs;
import org.junit.jupiter.api.condition.OS;
import org.junit.platform.commons.util.Preconditions;

class EnabledOnOsCondition
extends BooleanExecutionCondition<EnabledOnOs> {
    static final String ENABLED_ON_CURRENT_OS = "Enabled on operating system: " + System.getProperty("os.name");
    static final String DISABLED_ON_CURRENT_OS = "Disabled on operating system: " + System.getProperty("os.name");

    EnabledOnOsCondition() {
        super(EnabledOnOs.class, ENABLED_ON_CURRENT_OS, DISABLED_ON_CURRENT_OS, EnabledOnOs::disabledReason);
    }

    @Override
    boolean isEnabled(EnabledOnOs annotation) {
        OS[] operatingSystems = annotation.value();
        Preconditions.condition(operatingSystems.length > 0, "You must declare at least one OS in @EnabledOnOs");
        return Arrays.stream(operatingSystems).anyMatch(OS::isCurrentOs);
    }
}

