/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.util.function.Supplier;
import org.junit.jupiter.api.AssertionUtils;
import org.junit.jupiter.api.function.Executable;
import org.junit.platform.commons.util.UnrecoverableExceptions;
import org.opentest4j.AssertionFailedError;

class AssertThrowsExactly {
    private AssertThrowsExactly() {
    }

    static <T extends Throwable> T assertThrowsExactly(Class<T> expectedType, Executable executable) {
        return AssertThrowsExactly.assertThrowsExactly(expectedType, executable, null);
    }

    static <T extends Throwable> T assertThrowsExactly(Class<T> expectedType, Executable executable, String message2) {
        return AssertThrowsExactly.assertThrowsExactly(expectedType, executable, (Object)message2);
    }

    static <T extends Throwable> T assertThrowsExactly(Class<T> expectedType, Executable executable, Supplier<String> messageSupplier) {
        return AssertThrowsExactly.assertThrowsExactly(expectedType, executable, messageSupplier);
    }

    private static <T extends Throwable> T assertThrowsExactly(Class<T> expectedType, Executable executable, Object messageOrSupplier) {
        try {
            executable.execute();
        }
        catch (Throwable actualException) {
            if (expectedType.equals(actualException.getClass())) {
                return (T)actualException;
            }
            UnrecoverableExceptions.rethrowIfUnrecoverable(actualException);
            String message2 = AssertionUtils.buildPrefix(AssertionUtils.nullSafeGet(messageOrSupplier)) + AssertionUtils.format(expectedType, actualException.getClass(), "Unexpected exception type thrown");
            throw new AssertionFailedError(message2, actualException);
        }
        String message3 = AssertionUtils.buildPrefix(AssertionUtils.nullSafeGet(messageOrSupplier)) + String.format("Expected %s to be thrown, but nothing was thrown.", AssertionUtils.getCanonicalName(expectedType));
        throw new AssertionFailedError(message3);
    }
}

