/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.util.function.Supplier;
import org.junit.jupiter.api.AssertionUtils;
import org.opentest4j.AssertionFailedError;

class AssertInstanceOf {
    private AssertInstanceOf() {
    }

    static <T> T assertInstanceOf(Class<T> expectedType, Object actualValue) {
        return AssertInstanceOf.assertInstanceOf(expectedType, actualValue, null);
    }

    static <T> T assertInstanceOf(Class<T> expectedType, Object actualValue, String message2) {
        return AssertInstanceOf.assertInstanceOf(expectedType, actualValue, (Object)message2);
    }

    static <T> T assertInstanceOf(Class<T> expectedType, Object actualValue, Supplier<String> messageSupplier) {
        return AssertInstanceOf.assertInstanceOf(expectedType, actualValue, messageSupplier);
    }

    private static <T> T assertInstanceOf(Class<T> expectedType, Object actualValue, Object messageOrSupplier) {
        if (!expectedType.isInstance(actualValue)) {
            String reason = actualValue == null ? "Unexpected null value" : "Unexpected type";
            String message2 = AssertionUtils.buildPrefix(AssertionUtils.nullSafeGet(messageOrSupplier)) + AssertionUtils.format(expectedType, actualValue == null ? null : actualValue.getClass(), reason);
            throw new AssertionFailedError(message2);
        }
        return expectedType.cast(actualValue);
    }
}

