/*
 * Decompiled with CFR 0.152.
 */
package org.junit.internal.runners;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import org.junit.internal.runners.InitializationError;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.InvalidTestClassError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorReportingRunner
extends Runner {
    private final List<Throwable> causes;
    private final String classNames;

    public ErrorReportingRunner(Class<?> testClass, Throwable cause) {
        this(cause, testClass);
    }

    public ErrorReportingRunner(Throwable cause, Class<?> ... testClasses) {
        if (testClasses == null || testClasses.length == 0) {
            throw new NullPointerException("Test classes cannot be null or empty");
        }
        for (Class<?> testClass : testClasses) {
            if (testClass != null) continue;
            throw new NullPointerException("Test class cannot be null");
        }
        this.classNames = this.getClassNames(testClasses);
        this.causes = this.getCauses(cause);
    }

    @Override
    public Description getDescription() {
        Description description2 = Description.createSuiteDescription(this.classNames, new Annotation[0]);
        for (Throwable each : this.causes) {
            description2.addChild(this.describeCause());
        }
        return description2;
    }

    @Override
    public void run(RunNotifier notifier) {
        for (Throwable each : this.causes) {
            this.runCause(each, notifier);
        }
    }

    private String getClassNames(Class<?> ... testClasses) {
        StringBuilder builder2 = new StringBuilder();
        for (Class<?> testClass : testClasses) {
            if (builder2.length() != 0) {
                builder2.append(", ");
            }
            builder2.append(testClass.getName());
        }
        return builder2.toString();
    }

    private List<Throwable> getCauses(Throwable cause) {
        if (cause instanceof InvocationTargetException) {
            return this.getCauses(cause.getCause());
        }
        if (cause instanceof InvalidTestClassError) {
            return Collections.singletonList(cause);
        }
        if (cause instanceof org.junit.runners.model.InitializationError) {
            return ((org.junit.runners.model.InitializationError)cause).getCauses();
        }
        if (cause instanceof InitializationError) {
            return ((InitializationError)cause).getCauses();
        }
        return Collections.singletonList(cause);
    }

    private Description describeCause() {
        return Description.createTestDescription(this.classNames, "initializationError", new Annotation[0]);
    }

    private void runCause(Throwable child, RunNotifier notifier) {
        Description description2 = this.describeCause();
        notifier.fireTestStarted(description2);
        notifier.fireTestFailure(new Failure(description2, child));
        notifier.fireTestFinished(description2);
    }
}

