/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.log;

import java.io.PrintStream;
import java.security.AccessControlException;
import java.util.Map;
import java.util.Properties;
import org.eclipse.jetty.util.DateCache;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.log.AbstractLogger;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@ManagedObject(value="Jetty StdErr Logging Implementation")
public class StdErrLog
extends AbstractLogger {
    private static final String EOL;
    private static final Object[] EMPTY_ARGS;
    private static int __tagpad;
    private static DateCache _dateCache;
    private static final boolean __source;
    private static final boolean __long;
    private static final boolean __escape;
    private int _level;
    private int _configuredLevel;
    private PrintStream _altStream;
    private boolean _source;
    private boolean _printLongNames = __long;
    private final String _name;
    protected final String _abbrevname;
    private boolean _hideStacks = false;

    public static void setTagPad(int pad) {
        __tagpad = pad;
    }

    public static int getLoggingLevel(Properties props, String name) {
        int level = StdErrLog.lookupLoggingLevel(props, name);
        if (level == -1 && (level = StdErrLog.lookupLoggingLevel(props, "log")) == -1) {
            level = 2;
        }
        return level;
    }

    public static StdErrLog getLogger(Class<?> clazz) {
        Logger log = Log.getLogger(clazz);
        if (log instanceof StdErrLog) {
            return (StdErrLog)log;
        }
        throw new RuntimeException("Logger for " + clazz + " is not of type StdErrLog");
    }

    public StdErrLog() {
        this(null);
    }

    public StdErrLog(String name) {
        this(name, null);
    }

    public StdErrLog(String name, Properties props) {
        boolean sameObject;
        boolean bl = sameObject = props != Log.__props;
        if (props != null && sameObject) {
            Log.__props.putAll((Map<?, ?>)props);
        }
        this._name = name == null ? "" : name;
        this._abbrevname = StdErrLog.condensePackageString(this._name);
        this._configuredLevel = this._level = StdErrLog.getLoggingLevel(Log.__props, this._name);
        try {
            String source2 = StdErrLog.getLoggingProperty(Log.__props, this._name, "SOURCE");
            this._source = source2 == null ? __source : Boolean.parseBoolean(source2);
        }
        catch (AccessControlException ace) {
            this._source = __source;
        }
        try {
            String stacks = StdErrLog.getLoggingProperty(Log.__props, this._name, "STACKS");
            this._hideStacks = stacks != null && !Boolean.parseBoolean(stacks);
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    @Override
    public String getName() {
        return this._name;
    }

    public void setPrintLongNames(boolean printLongNames) {
        this._printLongNames = printLongNames;
    }

    public boolean isPrintLongNames() {
        return this._printLongNames;
    }

    public boolean isHideStacks() {
        return this._hideStacks;
    }

    public void setHideStacks(boolean hideStacks) {
        this._hideStacks = hideStacks;
    }

    public boolean isSource() {
        return this._source;
    }

    public void setSource(boolean source2) {
        this._source = source2;
    }

    @Override
    public void warn(String msg, Object ... args2) {
        if (this._level <= 3) {
            StringBuilder builder2 = new StringBuilder(64);
            this.format(builder2, ":WARN:", msg, args2);
            this.println(builder2);
        }
    }

    @Override
    public void warn(Throwable thrown) {
        this.warn("", thrown);
    }

    @Override
    public void warn(String msg, Throwable thrown) {
        if (this._level <= 3) {
            StringBuilder builder2 = new StringBuilder(64);
            this.format(builder2, ":WARN:", msg, thrown);
            this.println(builder2);
        }
    }

    @Override
    public void info(String msg, Object ... args2) {
        if (this._level <= 2) {
            StringBuilder builder2 = new StringBuilder(64);
            this.format(builder2, ":INFO:", msg, args2);
            this.println(builder2);
        }
    }

    @Override
    public void info(Throwable thrown) {
        this.info("", thrown);
    }

    @Override
    public void info(String msg, Throwable thrown) {
        if (this._level <= 2) {
            StringBuilder builder2 = new StringBuilder(64);
            this.format(builder2, ":INFO:", msg, thrown);
            this.println(builder2);
        }
    }

    @Override
    @ManagedAttribute(value="is debug enabled for root logger Log.LOG")
    public boolean isDebugEnabled() {
        return this._level <= 1;
    }

    @Override
    public void setDebugEnabled(boolean enabled) {
        int level = enabled ? 1 : this.getConfiguredLevel();
        this.setLevel(level);
        String name = this.getName();
        for (Logger log : Log.getLoggers().values()) {
            if (!log.getName().startsWith(name) || !(log instanceof StdErrLog)) continue;
            StdErrLog logger2 = (StdErrLog)log;
            level = enabled ? 1 : logger2.getConfiguredLevel();
            logger2.setLevel(level);
        }
    }

    private int getConfiguredLevel() {
        return this._configuredLevel;
    }

    public int getLevel() {
        return this._level;
    }

    public void setLevel(int level) {
        this._level = level;
    }

    public void setStdErrStream(PrintStream stream) {
        this._altStream = stream;
    }

    @Override
    public void debug(String msg, Object ... args2) {
        if (this.isDebugEnabled()) {
            StringBuilder builder2 = new StringBuilder(64);
            this.format(builder2, ":DBUG:", msg, args2);
            this.println(builder2);
        }
    }

    @Override
    public void debug(String msg, long arg) {
        if (this.isDebugEnabled()) {
            StringBuilder builder2 = new StringBuilder(64);
            this.format(builder2, ":DBUG:", msg, arg);
            this.println(builder2);
        }
    }

    @Override
    public void debug(Throwable thrown) {
        this.debug("", thrown);
    }

    @Override
    public void debug(String msg, Throwable thrown) {
        if (this.isDebugEnabled()) {
            StringBuilder builder2 = new StringBuilder(64);
            this.format(builder2, ":DBUG:", msg, thrown);
            this.println(builder2);
        }
    }

    private void println(StringBuilder builder2) {
        if (this._altStream != null) {
            this._altStream.println(builder2);
        } else {
            System.err.println(builder2);
        }
    }

    private void format(StringBuilder builder2, String level, String msg, Object ... inArgs) {
        long now = System.currentTimeMillis();
        int ms = (int)(now % 1000L);
        String d = _dateCache.formatNow(now);
        this.tag(builder2, d, ms, level);
        Object[] msgArgs = EMPTY_ARGS;
        int msgArgsLen = 0;
        Throwable cause = null;
        if (inArgs != null) {
            msgArgs = inArgs;
            msgArgsLen = inArgs.length;
            if (msgArgsLen > 0 && inArgs[msgArgsLen - 1] instanceof Throwable) {
                cause = (Throwable)inArgs[msgArgsLen - 1];
                --msgArgsLen;
            }
        }
        if (msg == null) {
            msg = "";
            for (int i2 = 0; i2 < msgArgsLen; ++i2) {
                msg = msg + "{} ";
            }
        }
        String braces = "{}";
        int start2 = 0;
        for (int i3 = 0; i3 < msgArgsLen; ++i3) {
            Object arg = msgArgs[i3];
            int bracesIndex = msg.indexOf(braces, start2);
            if (bracesIndex < 0) {
                this.escape(builder2, msg.substring(start2));
                builder2.append(" ");
                if (arg != null) {
                    builder2.append(arg);
                }
                start2 = msg.length();
                continue;
            }
            this.escape(builder2, msg.substring(start2, bracesIndex));
            if (arg != null) {
                builder2.append(arg);
            }
            start2 = bracesIndex + braces.length();
        }
        this.escape(builder2, msg.substring(start2));
        if (cause != null) {
            if (this.isHideStacks()) {
                builder2.append(": ").append(cause);
            } else {
                this.formatCause(builder2, cause, "");
            }
        }
    }

    private void formatCause(StringBuilder builder2, Throwable cause, String indent) {
        builder2.append(EOL).append(indent);
        this.escape(builder2, cause.toString());
        StackTraceElement[] elements = cause.getStackTrace();
        for (int i2 = 0; elements != null && i2 < elements.length; ++i2) {
            builder2.append(EOL).append(indent).append("\tat ");
            this.escape(builder2, elements[i2].toString());
        }
        for (Throwable suppressed : cause.getSuppressed()) {
            builder2.append(EOL).append(indent).append("Suppressed: ");
            this.formatCause(builder2, suppressed, "\t|" + indent);
        }
        Throwable by = cause.getCause();
        if (by != null && by != cause) {
            builder2.append(EOL).append(indent).append("Caused by: ");
            this.formatCause(builder2, by, indent);
        }
    }

    private void escape(StringBuilder builder2, String str) {
        if (__escape) {
            for (int i2 = 0; i2 < str.length(); ++i2) {
                char c = str.charAt(i2);
                if (Character.isISOControl(c)) {
                    if (c == '\n') {
                        builder2.append('|');
                        continue;
                    }
                    if (c == '\r') {
                        builder2.append('<');
                        continue;
                    }
                    builder2.append('?');
                    continue;
                }
                builder2.append(c);
            }
        } else {
            builder2.append(str);
        }
    }

    private void tag(StringBuilder builder2, String d, int ms, String tag) {
        int p;
        builder2.setLength(0);
        builder2.append(d);
        if (ms > 99) {
            builder2.append('.');
        } else if (ms > 9) {
            builder2.append(".0");
        } else {
            builder2.append(".00");
        }
        builder2.append(ms).append(tag);
        String name = this._printLongNames ? this._name : this._abbrevname;
        String tname = Thread.currentThread().getName();
        int n = p = __tagpad > 0 ? name.length() + tname.length() - __tagpad : 0;
        if (p < 0) {
            builder2.append(name).append(':').append("                                                  ", 0, -p).append(tname);
        } else if (p == 0) {
            builder2.append(name).append(':').append(tname);
        }
        builder2.append(':');
        if (this._source) {
            StackTraceElement[] frames;
            Throwable source2 = new Throwable();
            for (StackTraceElement frame : frames = source2.getStackTrace()) {
                String clazz = frame.getClassName();
                if (clazz.equals(StdErrLog.class.getName()) || clazz.equals(Log.class.getName())) continue;
                if (!this._printLongNames && clazz.startsWith("org.eclipse.jetty.")) {
                    builder2.append(StdErrLog.condensePackageString(clazz));
                } else {
                    builder2.append(clazz);
                }
                builder2.append('#').append(frame.getMethodName());
                if (frame.getFileName() != null) {
                    builder2.append('(').append(frame.getFileName()).append(':').append(frame.getLineNumber()).append(')');
                }
                builder2.append(':');
                break;
            }
        }
        builder2.append(' ');
    }

    @Override
    protected Logger newLogger(String fullname) {
        StdErrLog logger2 = new StdErrLog(fullname);
        logger2.setPrintLongNames(this._printLongNames);
        logger2._altStream = this._altStream;
        if (this._level != this._configuredLevel) {
            logger2._level = this._level;
        }
        return logger2;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("StdErrLog:");
        s.append(this._name);
        s.append(":LEVEL=");
        switch (this._level) {
            case 0: {
                s.append("ALL");
                break;
            }
            case 1: {
                s.append("DEBUG");
                break;
            }
            case 2: {
                s.append("INFO");
                break;
            }
            case 3: {
                s.append("WARN");
                break;
            }
            default: {
                s.append("?");
            }
        }
        return s.toString();
    }

    @Override
    public void ignore(Throwable ignored) {
        if (this._level <= 0) {
            StringBuilder builder2 = new StringBuilder(64);
            this.format(builder2, ":IGNORED:", "", ignored);
            this.println(builder2);
        }
    }

    static {
        String[] deprecatedProperties;
        EOL = System.lineSeparator();
        EMPTY_ARGS = new Object[0];
        __tagpad = Integer.parseInt(Log.__props.getProperty("org.eclipse.jetty.util.log.StdErrLog.TAG_PAD", "0"));
        __source = Boolean.parseBoolean(Log.__props.getProperty("org.eclipse.jetty.util.log.SOURCE", Log.__props.getProperty("org.eclipse.jetty.util.log.stderr.SOURCE", "false")));
        __long = Boolean.parseBoolean(Log.__props.getProperty("org.eclipse.jetty.util.log.stderr.LONG", "false"));
        __escape = Boolean.parseBoolean(Log.__props.getProperty("org.eclipse.jetty.util.log.stderr.ESCAPE", "true"));
        for (String deprecatedProp : deprecatedProperties = new String[]{"DEBUG", "org.eclipse.jetty.util.log.DEBUG", "org.eclipse.jetty.util.log.stderr.DEBUG"}) {
            if (System.getProperty(deprecatedProp) == null) continue;
            System.err.printf("System Property [%s] has been deprecated! (Use org.eclipse.jetty.LEVEL=DEBUG instead)%n", deprecatedProp);
        }
        try {
            _dateCache = new DateCache("yyyy-MM-dd HH:mm:ss");
        }
        catch (Exception x) {
            x.printStackTrace(System.err);
        }
    }
}

