/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.client.http;

import java.net.URI;
import java.util.function.Supplier;
import org.eclipse.jetty.client.HttpContent;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.HttpSender;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http2.ISession;
import org.eclipse.jetty.http2.IStream;
import org.eclipse.jetty.http2.api.Stream;
import org.eclipse.jetty.http2.client.http.HttpChannelOverHTTP2;
import org.eclipse.jetty.http2.frames.DataFrame;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Promise;

public class HttpSenderOverHTTP2
extends HttpSender {
    public HttpSenderOverHTTP2(HttpChannelOverHTTP2 channel2) {
        super(channel2);
    }

    @Override
    protected HttpChannelOverHTTP2 getHttpChannel() {
        return (HttpChannelOverHTTP2)super.getHttpChannel();
    }

    @Override
    protected void sendHeaders(HttpExchange exchange, HttpContent content2, Callback callback) {
        HeadersFrame headersFrame;
        HttpRequest request2 = exchange.getRequest();
        String path = this.relativize(request2.getPath());
        HttpURI uri2 = HttpURI.createHttpURI(request2.getScheme(), request2.getHost(), request2.getPort(), path, null, request2.getQuery(), null);
        MetaData.Request metaData = new MetaData.Request(request2.getMethod(), uri2, HttpVersion.HTTP_2, request2.getHeaders());
        metaData.setTrailerSupplier(request2.getTrailers());
        DataFrame dataFrame = null;
        HeadersFrame trailersFrame = null;
        if (content2.hasContent()) {
            headersFrame = new HeadersFrame(metaData, null, false);
            if (!this.expects100Continue(request2)) {
                boolean advanced = content2.advance();
                boolean lastContent = content2.isLast();
                if (advanced) {
                    if (lastContent) {
                        HttpFields trailers = this.retrieveTrailers(request2);
                        boolean hasTrailers = trailers != null;
                        dataFrame = new DataFrame(content2.getByteBuffer(), !hasTrailers);
                        if (hasTrailers) {
                            trailersFrame = new HeadersFrame(new MetaData(HttpVersion.HTTP_2, trailers), null, true);
                        }
                    } else {
                        dataFrame = new DataFrame(content2.getByteBuffer(), false);
                    }
                } else if (lastContent) {
                    HttpFields trailers = this.retrieveTrailers(request2);
                    if (trailers != null) {
                        trailersFrame = new HeadersFrame(new MetaData(HttpVersion.HTTP_2, trailers), null, true);
                    } else {
                        dataFrame = new DataFrame(BufferUtil.EMPTY_BUFFER, true);
                    }
                }
            }
        } else {
            HttpFields trailers = this.retrieveTrailers(request2);
            boolean hasTrailers = trailers != null;
            headersFrame = new HeadersFrame(metaData, null, !hasTrailers);
            if (hasTrailers) {
                trailersFrame = new HeadersFrame(new MetaData(HttpVersion.HTTP_2, trailers), null, true);
            }
        }
        HttpChannelOverHTTP2 channel2 = this.getHttpChannel();
        IStream.FrameList frameList = new IStream.FrameList(headersFrame, dataFrame, trailersFrame);
        ((ISession)channel2.getSession()).newStream(frameList, (Promise<Stream>)new HeadersPromise(request2, callback), channel2.getStreamListener());
    }

    private String relativize(String path) {
        try {
            String result2 = path;
            URI uri2 = URI.create(result2);
            if (uri2.isAbsolute()) {
                result2 = uri2.getPath();
            }
            return result2.isEmpty() ? "/" : result2;
        }
        catch (Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Could not relativize " + path, new Object[0]);
            }
            return path;
        }
    }

    private HttpFields retrieveTrailers(HttpRequest request2) {
        Supplier<HttpFields> trailerSupplier = request2.getTrailers();
        HttpFields trailers = trailerSupplier == null ? null : trailerSupplier.get();
        return trailers == null || trailers.size() == 0 ? null : trailers;
    }

    @Override
    protected void sendContent(HttpExchange exchange, HttpContent content2, Callback callback) {
        if (content2.isConsumed()) {
            callback.succeeded();
        } else {
            this.sendContent(this.getHttpChannel().getStream(), exchange.getRequest(), content2, callback);
        }
    }

    private void sendContent(Stream stream, HttpRequest request2, HttpContent content2, Callback callback) {
        if (content2.isLast()) {
            HttpFields trailers = this.retrieveTrailers(request2);
            boolean hasTrailers = trailers != null;
            DataFrame dataFrame = new DataFrame(stream.getId(), content2.getByteBuffer(), !hasTrailers);
            if (hasTrailers) {
                stream.data(dataFrame, Callback.from(() -> this.sendTrailers(stream, trailers, callback), callback::failed));
            } else {
                stream.data(dataFrame, callback);
            }
        } else {
            DataFrame dataFrame = new DataFrame(stream.getId(), content2.getByteBuffer(), false);
            stream.data(dataFrame, callback);
        }
    }

    private void sendTrailers(Stream stream, HttpFields trailers, Callback callback) {
        MetaData metaData = new MetaData(HttpVersion.HTTP_2, trailers);
        HeadersFrame trailersFrame = new HeadersFrame(stream.getId(), metaData, null, true);
        stream.headers(trailersFrame, callback);
    }

    private static class HeadersPromise
    implements Promise<Stream> {
        private final HttpRequest request;
        private final Callback callback;

        private HeadersPromise(HttpRequest request2, Callback callback) {
            this.request = request2;
            this.callback = callback;
        }

        @Override
        public void succeeded(Stream stream) {
            long idleTimeout = this.request.getIdleTimeout();
            if (idleTimeout >= 0L) {
                stream.setIdleTimeout(idleTimeout);
            }
            this.callback.succeeded();
        }

        @Override
        public void failed(Throwable x) {
            this.callback.failed(x);
        }
    }
}

