/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.client.http;

import java.nio.channels.AsynchronousCloseException;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jetty.client.ConnectionPool;
import org.eclipse.jetty.client.HttpChannel;
import org.eclipse.jetty.client.HttpConnection;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.SendFailure;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http2.ErrorCode;
import org.eclipse.jetty.http2.HTTP2Session;
import org.eclipse.jetty.http2.api.Session;
import org.eclipse.jetty.http2.client.http.HttpChannelOverHTTP2;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Sweeper;

public class HttpConnectionOverHTTP2
extends HttpConnection
implements Sweeper.Sweepable,
ConnectionPool.Multiplexable {
    private static final Logger LOG = Log.getLogger(HttpConnection.class);
    private final Set<HttpChannel> activeChannels = ConcurrentHashMap.newKeySet();
    private final Queue<HttpChannelOverHTTP2> idleChannels = new ConcurrentLinkedQueue<HttpChannelOverHTTP2>();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final AtomicInteger sweeps = new AtomicInteger();
    private final Session session;
    private boolean recycleHttpChannels = true;

    public HttpConnectionOverHTTP2(HttpDestination destination, Session session2) {
        super(destination);
        this.session = session2;
    }

    public Session getSession() {
        return this.session;
    }

    public boolean isRecycleHttpChannels() {
        return this.recycleHttpChannels;
    }

    public void setRecycleHttpChannels(boolean recycleHttpChannels) {
        this.recycleHttpChannels = recycleHttpChannels;
    }

    @Override
    public int getMaxMultiplex() {
        return ((HTTP2Session)this.session).getMaxLocalStreams();
    }

    @Override
    protected Iterator<HttpChannel> getHttpChannels() {
        return this.activeChannels.iterator();
    }

    @Override
    protected SendFailure send(HttpExchange exchange) {
        HttpRequest request2 = exchange.getRequest();
        request2.version(HttpVersion.HTTP_2);
        this.normalizeRequest(request2);
        HttpChannelOverHTTP2 channel2 = this.acquireHttpChannel();
        this.activeChannels.add(channel2);
        return this.send(channel2, exchange);
    }

    protected HttpChannelOverHTTP2 acquireHttpChannel() {
        HttpChannelOverHTTP2 channel2 = this.idleChannels.poll();
        if (channel2 == null) {
            channel2 = this.newHttpChannel();
        }
        return channel2;
    }

    protected HttpChannelOverHTTP2 newHttpChannel() {
        return new HttpChannelOverHTTP2(this.getHttpDestination(), this, this.getSession());
    }

    protected boolean release(HttpChannelOverHTTP2 channel2) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Released {}", channel2);
        }
        if (this.activeChannels.remove(channel2)) {
            if (channel2.isFailed()) {
                channel2.destroy();
            } else if (this.isRecycleHttpChannels()) {
                this.idleChannels.offer(channel2);
            }
            return true;
        }
        channel2.destroy();
        return false;
    }

    @Override
    public boolean onIdleTimeout(long idleTimeout) {
        boolean close2 = super.onIdleTimeout(idleTimeout);
        if (close2) {
            this.close(new TimeoutException("idle_timeout"));
        }
        return false;
    }

    @Override
    public void close() {
        this.close(new AsynchronousCloseException());
        this.destroy();
    }

    protected void close(Throwable failure) {
        if (this.closed.compareAndSet(false, true)) {
            this.getHttpDestination().remove(this);
            this.abort(failure);
            this.session.close(ErrorCode.NO_ERROR.code, failure.getMessage(), Callback.NOOP);
            HttpChannel channel2 = this.idleChannels.poll();
            while (channel2 != null) {
                channel2.destroy();
                channel2 = this.idleChannels.poll();
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    private void abort(Throwable failure) {
        for (HttpChannel channel2 : this.activeChannels) {
            HttpExchange exchange = channel2.getHttpExchange();
            if (exchange == null) continue;
            exchange.getRequest().abort(failure);
        }
        this.activeChannels.clear();
        HttpChannel channel3 = this.idleChannels.poll();
        while (channel3 != null) {
            channel3.destroy();
            channel3 = this.idleChannels.poll();
        }
    }

    @Override
    public boolean sweep() {
        if (!this.isClosed()) {
            return false;
        }
        return this.sweeps.incrementAndGet() >= 4;
    }

    @Override
    public String toString() {
        return String.format("%s@%x(closed=%b)[%s]", this.getClass().getSimpleName(), this.hashCode(), this.isClosed(), this.session);
    }
}

