/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.io.CyclicTimeout;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;

@Deprecated
public class TimeoutCompleteListener
extends CyclicTimeout
implements Response.CompleteListener {
    private static final Logger LOG = Log.getLogger(TimeoutCompleteListener.class);
    private final AtomicReference<Request> requestTimeout = new AtomicReference();

    public TimeoutCompleteListener(Scheduler scheduler) {
        super(scheduler);
    }

    @Override
    public void onTimeoutExpired() {
        Request request2 = this.requestTimeout.getAndSet(null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Total timeout {} ms elapsed for {} on {}", request2.getTimeout(), request2, this);
        }
        if (request2 != null) {
            request2.abort(new TimeoutException("Total timeout " + request2.getTimeout() + " ms elapsed"));
        }
    }

    @Override
    public void onComplete(Result result2) {
        Request request2 = this.requestTimeout.getAndSet(null);
        if (request2 != null) {
            boolean cancelled = this.cancel();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cancelled ({}) timeout for {} on {}", cancelled, request2, this);
            }
        }
    }

    void schedule(HttpRequest request2, long timeoutAt) {
        if (this.requestTimeout.compareAndSet(null, request2)) {
            long delay2 = Math.max(0L, timeoutAt - System.nanoTime());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Scheduling timeout in {} ms for {} on {}", TimeUnit.NANOSECONDS.toMillis(delay2), request2, this);
            }
            this.schedule(delay2, TimeUnit.NANOSECONDS);
        }
    }
}

