/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jetty.client.Origin;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.util.HostPort;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class ProxyConfiguration {
    private final List<Proxy> proxies = new ArrayList<Proxy>();

    public List<Proxy> getProxies() {
        return this.proxies;
    }

    public Proxy match(Origin origin2) {
        for (Proxy proxy2 : this.getProxies()) {
            if (!proxy2.matches(origin2)) continue;
            return proxy2;
        }
        return null;
    }

    public static abstract class Proxy {
        private final Set<String> included = new HashSet<String>();
        private final Set<String> excluded = new HashSet<String>();
        private final Origin.Address address;
        private final boolean secure;
        private final SslContextFactory.Client sslContextFactory;

        protected Proxy(Origin.Address address, boolean secure) {
            this(address, secure, null);
        }

        protected Proxy(Origin.Address address, SslContextFactory.Client sslContextFactory) {
            this(address, true, Objects.requireNonNull(sslContextFactory));
        }

        private Proxy(Origin.Address address, boolean secure, SslContextFactory.Client sslContextFactory) {
            this.address = address;
            this.secure = secure;
            this.sslContextFactory = sslContextFactory;
        }

        public Origin.Address getAddress() {
            return this.address;
        }

        public boolean isSecure() {
            return this.secure;
        }

        public SslContextFactory.Client getSslContextFactory() {
            return this.sslContextFactory;
        }

        public Set<String> getIncludedAddresses() {
            return this.included;
        }

        public Set<String> getExcludedAddresses() {
            return this.excluded;
        }

        public URI getURI() {
            return null;
        }

        public boolean matches(Origin origin2) {
            if (this.getAddress().equals(origin2.getAddress())) {
                return false;
            }
            boolean result2 = this.included.isEmpty();
            Origin.Address address = origin2.getAddress();
            for (String included : this.included) {
                if (!this.matches(address, included)) continue;
                result2 = true;
                break;
            }
            for (String excluded : this.excluded) {
                if (!this.matches(address, excluded)) continue;
                result2 = false;
                break;
            }
            return result2;
        }

        private boolean matches(Origin.Address address, String pattern) {
            HostPort hostPort = new HostPort(pattern);
            String host2 = hostPort.getHost();
            int port2 = hostPort.getPort();
            return host2.equals(address.getHost()) && (port2 <= 0 || port2 == address.getPort());
        }

        public abstract ClientConnectionFactory newClientConnectionFactory(ClientConnectionFactory var1);

        public String toString() {
            return this.address.toString();
        }
    }
}

