/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpContentResponse;
import org.eclipse.jetty.client.HttpConversation;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.HttpResponseException;
import org.eclipse.jetty.client.ResponseNotifier;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.client.util.BufferingResponseListener;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HttpRedirector {
    private static final Logger LOG = Log.getLogger(HttpRedirector.class);
    private static final String SCHEME_REGEXP = "(^https?)";
    private static final String AUTHORITY_REGEXP = "([^/?#]+)";
    private static final String DESTINATION_REGEXP = "((^https?)://([^/?#]+))?";
    private static final String PATH_REGEXP = "([^?#]*)";
    private static final String QUERY_REGEXP = "([^#]*)";
    private static final String FRAGMENT_REGEXP = "(.*)";
    private static final Pattern URI_PATTERN = Pattern.compile("((^https?)://([^/?#]+))?([^?#]*)([^#]*)(.*)");
    private static final String ATTRIBUTE = HttpRedirector.class.getName() + ".redirects";
    private final HttpClient client;
    private final ResponseNotifier notifier;

    public HttpRedirector(HttpClient client2) {
        this.client = client2;
        this.notifier = new ResponseNotifier();
    }

    public boolean isRedirect(Response response2) {
        switch (response2.getStatus()) {
            case 301: 
            case 302: 
            case 303: 
            case 307: 
            case 308: {
                return true;
            }
        }
        return false;
    }

    public Result redirect(Request request2, Response response2) throws InterruptedException, ExecutionException {
        final AtomicReference resultRef = new AtomicReference();
        final CountDownLatch latch = new CountDownLatch(1);
        Request redirect = this.redirect(request2, response2, new BufferingResponseListener(){

            @Override
            public void onComplete(Result result2) {
                resultRef.set(new Result(result2.getRequest(), result2.getRequestFailure(), new HttpContentResponse(result2.getResponse(), this.getContent(), this.getMediaType(), this.getEncoding()), result2.getResponseFailure()));
                latch.countDown();
            }
        });
        try {
            latch.await();
            Result result2 = (Result)resultRef.get();
            if (result2.isFailed()) {
                throw new ExecutionException(result2.getFailure());
            }
            return result2;
        }
        catch (InterruptedException x) {
            redirect.abort(x);
            throw x;
        }
    }

    public Request redirect(Request request2, Response response2, Response.CompleteListener listener) {
        if (this.isRedirect(response2)) {
            String location = response2.getHeaders().get("Location");
            URI newURI = this.extractRedirectURI(response2);
            if (newURI != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Redirecting to {} (Location: {})", newURI, location);
                }
                return this.redirect(request2, response2, listener, newURI);
            }
            this.fail(request2, response2, new HttpResponseException("Invalid 'Location' header: " + location, response2));
            return null;
        }
        this.fail(request2, response2, new HttpResponseException("Cannot redirect: " + response2, response2));
        return null;
    }

    public URI extractRedirectURI(Response response2) {
        String location = response2.getHeaders().get("location");
        if (location != null) {
            return this.sanitize(location);
        }
        return null;
    }

    private URI sanitize(String location) {
        try {
            return new URI(location);
        }
        catch (URISyntaxException x) {
            Matcher matcher = URI_PATTERN.matcher(location);
            if (matcher.matches()) {
                String fragment;
                String scheme2 = matcher.group(2);
                String authority = matcher.group(3);
                String path = matcher.group(4);
                String query = matcher.group(5);
                if (query.length() == 0) {
                    query = null;
                }
                if ((fragment = matcher.group(6)).length() == 0) {
                    fragment = null;
                }
                try {
                    return new URI(scheme2, authority, path, query, fragment);
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    private Request redirect(Request request2, Response response2, Response.CompleteListener listener, URI newURI) {
        if (!newURI.isAbsolute()) {
            URI requestURI = request2.getURI();
            if (requestURI == null) {
                String uri2 = request2.getScheme() + "://" + request2.getHost();
                int port2 = request2.getPort();
                if (port2 > 0) {
                    uri2 = uri2 + ":" + port2;
                }
                requestURI = URI.create(uri2);
            }
            newURI = requestURI.resolve(newURI);
        }
        int status2 = response2.getStatus();
        switch (status2) {
            case 301: {
                String method2 = request2.getMethod();
                if (HttpMethod.GET.is(method2) || HttpMethod.HEAD.is(method2) || HttpMethod.PUT.is(method2)) {
                    return this.redirect(request2, response2, listener, newURI, method2);
                }
                if (HttpMethod.POST.is(method2)) {
                    return this.redirect(request2, response2, listener, newURI, HttpMethod.GET.asString());
                }
                this.fail(request2, response2, new HttpResponseException("HTTP protocol violation: received 301 for non GET/HEAD/POST/PUT request", response2));
                return null;
            }
            case 302: {
                String method2 = request2.getMethod();
                if (HttpMethod.HEAD.is(method2) || HttpMethod.PUT.is(method2)) {
                    return this.redirect(request2, response2, listener, newURI, method2);
                }
                return this.redirect(request2, response2, listener, newURI, HttpMethod.GET.asString());
            }
            case 303: {
                String method2 = request2.getMethod();
                if (HttpMethod.HEAD.is(method2)) {
                    return this.redirect(request2, response2, listener, newURI, method2);
                }
                return this.redirect(request2, response2, listener, newURI, HttpMethod.GET.asString());
            }
            case 307: 
            case 308: {
                return this.redirect(request2, response2, listener, newURI, request2.getMethod());
            }
        }
        this.fail(request2, response2, new HttpResponseException("Unhandled HTTP status code " + status2, response2));
        return null;
    }

    private Request redirect(Request request2, Response response2, Response.CompleteListener listener, URI location, String method2) {
        int maxRedirects;
        HttpRequest httpRequest = (HttpRequest)request2;
        HttpConversation conversation = httpRequest.getConversation();
        Integer redirects = (Integer)conversation.getAttribute(ATTRIBUTE);
        if (redirects == null) {
            redirects = 0;
        }
        if ((maxRedirects = this.client.getMaxRedirects()) < 0 || redirects < maxRedirects) {
            redirects = redirects + 1;
            conversation.setAttribute(ATTRIBUTE, redirects);
            return this.sendRedirect(httpRequest, response2, listener, location, method2);
        }
        this.fail(request2, response2, new HttpResponseException("Max redirects exceeded " + redirects, response2));
        return null;
    }

    private Request sendRedirect(HttpRequest httpRequest, Response response2, Response.CompleteListener listener, URI location, String method2) {
        try {
            Request redirect = this.client.copyRequest(httpRequest, location);
            long timeoutAt = httpRequest.getTimeoutAt();
            if (timeoutAt < Long.MAX_VALUE) {
                long newTimeout = timeoutAt - System.nanoTime();
                if (newTimeout > 0L) {
                    redirect.timeout(newTimeout, TimeUnit.NANOSECONDS);
                } else {
                    TimeoutException failure = new TimeoutException("Total timeout " + httpRequest.getConversation().getTimeout() + " ms elapsed");
                    this.fail((Request)httpRequest, failure, response2);
                    return null;
                }
            }
            redirect.method(method2);
            redirect.onRequestBegin(request2 -> {
                Throwable cause = httpRequest.getAbortCause();
                if (cause != null) {
                    request2.abort(cause);
                }
            });
            redirect.send(listener);
            return redirect;
        }
        catch (Throwable x) {
            this.fail((Request)httpRequest, x, response2);
            return null;
        }
    }

    protected void fail(Request request2, Response response2, Throwable failure) {
        this.fail(request2, null, response2, failure);
    }

    protected void fail(Request request2, Throwable failure, Response response2) {
        this.fail(request2, failure, response2, failure);
    }

    private void fail(Request request2, Throwable requestFailure, Response response2, Throwable responseFailure) {
        HttpConversation conversation = ((HttpRequest)request2).getConversation();
        conversation.updateResponseListeners(null);
        List<Response.ResponseListener> listeners = conversation.getResponseListeners();
        this.notifier.notifyFailure(listeners, response2, responseFailure);
        this.notifier.notifyComplete(listeners, new Result(request2, requestFailure, response2, responseFailure));
    }
}

