/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.eclipse.jetty.client.ConnectionPool;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.api.Connection;
import org.eclipse.jetty.client.api.Destination;
import org.eclipse.jetty.util.Attachable;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.Pool;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Sweeper;

@ManagedObject
public abstract class AbstractConnectionPool
extends ContainerLifeCycle
implements ConnectionPool,
Dumpable,
Sweeper.Sweepable {
    private static final Logger LOG = Log.getLogger(AbstractConnectionPool.class);
    private final AtomicInteger pending = new AtomicInteger();
    private final HttpDestination destination;
    private final Callback requester;
    private final Pool<Connection> pool;
    private boolean maximizeConnections;
    private volatile long maxDurationNanos = 0L;

    @Deprecated
    protected AbstractConnectionPool(Destination destination, int maxConnections, Callback requester) {
        this((HttpDestination)destination, maxConnections, false, requester);
    }

    protected AbstractConnectionPool(HttpDestination destination, int maxConnections, boolean cache2, Callback requester) {
        this(destination, Pool.StrategyType.FIRST, maxConnections, cache2, requester);
    }

    protected AbstractConnectionPool(HttpDestination destination, Pool.StrategyType strategy, int maxConnections, boolean cache2, Callback requester) {
        this(destination, new Pool<Connection>(strategy, maxConnections, cache2), requester);
    }

    protected AbstractConnectionPool(HttpDestination destination, Pool<Connection> pool, Callback requester) {
        this.destination = destination;
        this.requester = requester;
        this.pool = pool;
        pool.setMaxMultiplex(1);
        this.addBean(pool);
    }

    @Override
    protected void doStop() throws Exception {
        this.pool.close();
    }

    @Override
    public CompletableFuture<Void> preCreateConnections(int connectionCount) {
        Pool.Entry entry;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Pre-creating connections {}/{}", connectionCount, this.getMaxConnectionCount());
        }
        ArrayList<FutureConnection> futures = new ArrayList<FutureConnection>();
        for (int i2 = 0; i2 < connectionCount && (entry = this.pool.reserve()) != null; ++i2) {
            this.pending.incrementAndGet();
            FutureConnection future = new FutureConnection(entry);
            futures.add(future);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Pre-creating connection {}/{} at {}", futures.size(), this.getMaxConnectionCount(), entry);
            }
            this.destination.newConnection(future);
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
    }

    @ManagedAttribute(value="The maximum duration in milliseconds a connection can be used for before it gets closed")
    public long getMaxDuration() {
        return TimeUnit.NANOSECONDS.toMillis(this.maxDurationNanos);
    }

    public void setMaxDuration(long maxDurationInMs) {
        this.maxDurationNanos = TimeUnit.MILLISECONDS.toNanos(maxDurationInMs);
    }

    protected int getMaxMultiplex() {
        return this.pool.getMaxMultiplex();
    }

    protected void setMaxMultiplex(int maxMultiplex) {
        this.pool.setMaxMultiplex(maxMultiplex);
    }

    protected int getMaxUsageCount() {
        return this.pool.getMaxUsageCount();
    }

    protected void setMaxUsageCount(int maxUsageCount) {
        this.pool.setMaxUsageCount(maxUsageCount);
    }

    @ManagedAttribute(value="The number of active connections", readonly=true)
    public int getActiveConnectionCount() {
        return this.pool.getInUseCount();
    }

    @ManagedAttribute(value="The number of idle connections", readonly=true)
    public int getIdleConnectionCount() {
        return this.pool.getIdleCount();
    }

    @ManagedAttribute(value="The max number of connections", readonly=true)
    public int getMaxConnectionCount() {
        return this.pool.getMaxEntries();
    }

    @ManagedAttribute(value="The number of connections", readonly=true)
    public int getConnectionCount() {
        return this.pool.size();
    }

    @ManagedAttribute(value="The number of pending connections", readonly=true)
    @Deprecated
    public int getPendingCount() {
        return this.getPendingConnectionCount();
    }

    @ManagedAttribute(value="The number of pending connections", readonly=true)
    public int getPendingConnectionCount() {
        return this.pending.get();
    }

    @Override
    public boolean isEmpty() {
        return this.pool.size() == 0;
    }

    @Override
    @ManagedAttribute(value="Whether this pool is closed")
    public boolean isClosed() {
        return this.pool.isClosed();
    }

    @ManagedAttribute(value="Whether the pool tries to maximize the number of connections used")
    public boolean isMaximizeConnections() {
        return this.maximizeConnections;
    }

    public void setMaximizeConnections(boolean maximizeConnections) {
        this.maximizeConnections = maximizeConnections;
    }

    @Override
    public Connection acquire() {
        return this.acquire(true);
    }

    protected Connection acquire(boolean create2) {
        Connection connection;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Acquiring create={} on {}", create2, this);
        }
        if ((connection = this.activate()) == null) {
            this.tryCreate(create2);
            connection = this.activate();
        }
        return connection;
    }

    protected void tryCreate(boolean create2) {
        int pending;
        int connectionCount = this.getConnectionCount();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Try creating connection {}/{} with {} pending", connectionCount, this.getMaxConnectionCount(), this.getPendingConnectionCount());
        }
        int multiplexed = this.getMaxMultiplex();
        do {
            boolean tryCreate;
            pending = this.pending.get();
            int supply = pending * multiplexed;
            int demand = this.destination.getQueuedRequestCount() + (create2 ? 1 : 0);
            boolean bl = tryCreate = this.isMaximizeConnections() || supply < demand;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Try creating({}) connection, pending/demand/supply: {}/{}/{}, result={}", create2, pending, demand, supply, tryCreate);
            }
            if (tryCreate) continue;
            return;
        } while (!this.pending.compareAndSet(pending, pending + 1));
        Pool.Entry entry = this.pool.reserve();
        if (entry == null) {
            this.pending.decrementAndGet();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Not creating connection as pool {} is full, pending: {}", this.pool, this.pending);
            }
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating connection {}/{} at {}", connectionCount, this.getMaxConnectionCount(), entry);
        }
        FutureConnection future = new FutureConnection(entry);
        this.destination.newConnection(future);
    }

    protected void proceed() {
        this.requester.succeeded();
    }

    protected Connection activate() {
        Pool.Entry entry;
        while ((entry = this.pool.acquire()) != null) {
            EntryHolder holder;
            Connection connection = (Connection)entry.getPooled();
            long maxDurationNanos = this.maxDurationNanos;
            if (maxDurationNanos > 0L && (holder = (EntryHolder)((Attachable)((Object)connection)).getAttachment()).isExpired(maxDurationNanos)) {
                boolean canClose = this.remove(connection);
                if (canClose) {
                    IO.close(connection);
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Connection removed{} due to expiration {} {}", canClose ? " and closed" : "", entry, this.pool);
                continue;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Activated {} {}", entry, this.pool);
            }
            this.acquired(connection);
            return connection;
        }
        return null;
    }

    @Override
    public boolean isActive(Connection connection) {
        if (!(connection instanceof Attachable)) {
            throw new IllegalArgumentException("Invalid connection object: " + connection);
        }
        Attachable attachable = (Attachable)((Object)connection);
        EntryHolder holder = (EntryHolder)attachable.getAttachment();
        if (holder == null) {
            return false;
        }
        return !holder.entry.isIdle();
    }

    @Override
    public boolean release(Connection connection) {
        if (!this.deactivate(connection)) {
            return false;
        }
        this.released(connection);
        return this.idle(connection, this.isClosed());
    }

    protected boolean deactivate(Connection connection) {
        if (!(connection instanceof Attachable)) {
            throw new IllegalArgumentException("Invalid connection object: " + connection);
        }
        Attachable attachable = (Attachable)((Object)connection);
        EntryHolder holder = (EntryHolder)attachable.getAttachment();
        if (holder == null) {
            return true;
        }
        long maxDurationNanos = this.maxDurationNanos;
        if (maxDurationNanos > 0L && holder.isExpired(maxDurationNanos)) {
            return !this.remove(connection);
        }
        boolean reusable = this.pool.release(holder.entry);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Released ({}) {} {}", reusable, holder.entry, this.pool);
        }
        if (reusable) {
            return true;
        }
        return !this.remove(connection);
    }

    @Override
    public boolean remove(Connection connection) {
        if (!(connection instanceof Attachable)) {
            throw new IllegalArgumentException("Invalid connection object: " + connection);
        }
        Attachable attachable = (Attachable)((Object)connection);
        EntryHolder holder = (EntryHolder)attachable.getAttachment();
        if (holder == null) {
            return false;
        }
        boolean removed = this.pool.remove(holder.entry);
        if (removed) {
            attachable.setAttachment(null);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removed ({}) {} {}", removed, holder.entry, this.pool);
        }
        if (removed) {
            this.released(connection);
            this.removed(connection);
        }
        return removed;
    }

    @Deprecated
    protected boolean remove(Connection connection, boolean force) {
        return this.remove(connection);
    }

    protected void onCreated(Connection connection) {
    }

    protected boolean idle(Connection connection, boolean close2) {
        return !close2;
    }

    protected void acquired(Connection connection) {
    }

    protected void released(Connection connection) {
    }

    protected void removed(Connection connection) {
    }

    @Deprecated
    public Queue<Connection> getIdleConnections() {
        return this.pool.values().stream().filter(Pool.Entry::isIdle).filter(entry -> !entry.isClosed()).map(Pool.Entry::getPooled).collect(Collectors.toCollection(ArrayDeque::new));
    }

    @Deprecated
    public Collection<Connection> getActiveConnections() {
        return this.pool.values().stream().filter(entry -> !entry.isIdle()).filter(entry -> !entry.isClosed()).map(Pool.Entry::getPooled).collect(Collectors.toList());
    }

    @Override
    public void close() {
        this.pool.close();
    }

    @Override
    public void dump(Appendable out2, String indent) throws IOException {
        Dumpable.dumpObjects(out2, indent, this, new Object[0]);
    }

    @Override
    public boolean sweep() {
        this.pool.values().stream().map(Pool.Entry::getPooled).filter(connection -> connection instanceof Sweeper.Sweepable).forEach(connection -> {
            if (((Sweeper.Sweepable)((Object)connection)).sweep()) {
                boolean removed = this.remove((Connection)connection);
                LOG.warn("Connection swept: {}{}{} from active connections{}{}", connection, System.lineSeparator(), removed ? "Removed" : "Not removed", System.lineSeparator(), this.dump());
            }
        });
        return false;
    }

    @Override
    public String toString() {
        return String.format("%s@%x[s=%s,c=%d/%d/%d,a=%d,i=%d,q=%d,p=%s]", this.getClass().getSimpleName(), this.hashCode(), this.getState(), this.getPendingConnectionCount(), this.getConnectionCount(), this.getMaxConnectionCount(), this.getActiveConnectionCount(), this.getIdleConnectionCount(), this.destination.getQueuedRequestCount(), this.pool);
    }

    private static class EntryHolder {
        private final Pool.Entry entry;
        private final long creationTimestamp = System.nanoTime();

        private EntryHolder(Pool.Entry entry) {
            this.entry = Objects.requireNonNull(entry);
        }

        private boolean isExpired(long timeoutNanos) {
            return System.nanoTime() - this.creationTimestamp >= timeoutNanos;
        }
    }

    private class FutureConnection
    extends Promise.Completable<Connection> {
        private final Pool.Entry reserved;

        public FutureConnection(Pool.Entry reserved) {
            this.reserved = reserved;
        }

        @Override
        public void succeeded(Connection connection) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Connection creation succeeded {}: {}", this.reserved, connection);
            }
            if (connection instanceof Attachable) {
                ((Attachable)((Object)connection)).setAttachment(new EntryHolder(this.reserved));
                AbstractConnectionPool.this.onCreated(connection);
                AbstractConnectionPool.this.pending.decrementAndGet();
                this.reserved.enable(connection, false);
                AbstractConnectionPool.this.idle(connection, false);
                this.complete(null);
                AbstractConnectionPool.this.proceed();
            } else {
                this.failed(new IllegalArgumentException("Invalid connection object: " + connection));
            }
        }

        @Override
        public void failed(Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Connection creation failed {}", this.reserved, x);
            }
            AbstractConnectionPool.this.pending.decrementAndGet();
            this.reserved.remove();
            this.completeExceptionally(x);
            AbstractConnectionPool.this.requester.failed(x);
        }
    }
}

