/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.util;

import org.assertj.core.api.filter.FilterOperator;

public final class Preconditions {
    public static final String ARGUMENT_EMPTY = "Argument expected not to be empty!";

    public static CharSequence checkNotNullOrEmpty(CharSequence s) {
        return Preconditions.checkNotNullOrEmpty(s, ARGUMENT_EMPTY);
    }

    public static CharSequence checkNotNullOrEmpty(CharSequence s, String message2) {
        Preconditions.checkNotNull(s, message2);
        if (s.length() == 0) {
            Preconditions.throwExceptionForBeingEmpty(message2);
        }
        return s;
    }

    public static <T> T[] checkNotNullOrEmpty(T[] array) {
        T[] checked = Preconditions.checkNotNull(array);
        if (checked.length == 0) {
            Preconditions.throwExceptionForBeingEmpty();
        }
        return checked;
    }

    public static <T> T checkNotNull(T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }

    public static <T> T checkNotNull(T reference, String message2) {
        if (reference == null) {
            throw new NullPointerException(message2);
        }
        return reference;
    }

    public static <T> void checkNotNull(FilterOperator<T> filterOperator) {
        Preconditions.checkArgument(filterOperator != null, "The expected value should not be null.%nIf you were trying to filter on a null value, please use filteredOnNull(String propertyOrFieldName) instead", new Object[0]);
    }

    public static void checkArgument(boolean expression, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression) {
            throw new IllegalArgumentException(String.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    public static void checkState(boolean expression, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression) {
            throw new IllegalStateException(String.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    private Preconditions() {
    }

    private static void throwExceptionForBeingEmpty() {
        Preconditions.throwExceptionForBeingEmpty(ARGUMENT_EMPTY);
    }

    private static void throwExceptionForBeingEmpty(String message2) {
        throw new IllegalArgumentException(message2);
    }
}

