/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal.bytebuddy;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.assertj.core.internal.bytebuddy.utility.CompoundList;

public class TypeCache<T>
extends ReferenceQueue<ClassLoader> {
    private static final Class<?> NOT_FOUND = null;
    protected final Sort sort;
    protected final ConcurrentMap<StorageKey, ConcurrentMap<T, Reference<Class<?>>>> cache;

    public TypeCache(Sort sort) {
        this.sort = sort;
        this.cache = new ConcurrentHashMap();
    }

    @SuppressFBWarnings(value={"GC_UNRELATED_TYPES"}, justification="Cross-comparison is intended")
    public Class<?> find(ClassLoader classLoader, T key2) {
        ConcurrentMap storage2 = (ConcurrentMap)this.cache.get(new LookupKey(classLoader));
        if (storage2 == null) {
            return NOT_FOUND;
        }
        Reference reference = (Reference)storage2.get(key2);
        if (reference == null) {
            return NOT_FOUND;
        }
        return (Class)reference.get();
    }

    @SuppressFBWarnings(value={"GC_UNRELATED_TYPES"}, justification="Cross-comparison is intended")
    public Class<?> insert(ClassLoader classLoader, T key2, Class<?> type2) {
        ConcurrentMap previous;
        ConcurrentMap<T, Reference<Class<?>>> storage2 = (ConcurrentHashMap)this.cache.get(new LookupKey(classLoader));
        if (storage2 == null && (previous = (ConcurrentMap)this.cache.putIfAbsent(new StorageKey(classLoader, this), storage2 = new ConcurrentHashMap())) != null) {
            storage2 = previous;
        }
        Reference<Class<?>> reference = this.sort.wrap(type2);
        Reference<Class<?>> previous2 = storage2.putIfAbsent(key2, reference);
        while (previous2 != null) {
            Class<?> previousType = previous2.get();
            if (previousType != null) {
                return previousType;
            }
            if (storage2.remove(key2, previous2)) {
                previous2 = storage2.putIfAbsent(key2, reference);
                continue;
            }
            previous2 = (Reference<Class<?>>)storage2.get(key2);
            if (previous2 != null) continue;
            previous2 = storage2.putIfAbsent(key2, reference);
        }
        return type2;
    }

    public Class<?> findOrInsert(ClassLoader classLoader, T key2, Callable<Class<?>> lazy) {
        Class<?> type2 = this.find(classLoader, key2);
        if (type2 != null) {
            return type2;
        }
        try {
            return this.insert(classLoader, key2, lazy.call());
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException("Could not create type", throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> findOrInsert(ClassLoader classLoader, T key2, Callable<Class<?>> lazy, Object monitor) {
        Class<?> type2 = this.find(classLoader, key2);
        if (type2 != null) {
            return type2;
        }
        Object object = monitor;
        synchronized (object) {
            return this.findOrInsert(classLoader, key2, lazy);
        }
    }

    public void expungeStaleEntries() {
        Reference reference;
        while ((reference = this.poll()) != null) {
            this.cache.remove(reference);
        }
    }

    public void clear() {
        this.cache.clear();
    }

    public static class SimpleKey {
        private final Set<String> types = new HashSet<String>();

        public SimpleKey(Class<?> type2, Class<?> ... additionalType) {
            this(type2, Arrays.asList(additionalType));
        }

        public SimpleKey(Class<?> type2, Collection<? extends Class<?>> additionalTypes) {
            this(CompoundList.of(type2, new ArrayList(additionalTypes)));
        }

        public SimpleKey(Collection<? extends Class<?>> types) {
            for (Class<?> type2 : types) {
                this.types.add(type2.getName());
            }
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            SimpleKey simpleKey = (SimpleKey)other;
            return this.types.equals(simpleKey.types);
        }

        public int hashCode() {
            return this.types.hashCode();
        }
    }

    public static class WithInlineExpunction<S>
    extends TypeCache<S> {
        public WithInlineExpunction(Sort sort) {
            super(sort);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Class<?> find(ClassLoader classLoader, S key2) {
            try {
                Class<?> clazz = super.find(classLoader, key2);
                return clazz;
            }
            finally {
                this.expungeStaleEntries();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Class<?> insert(ClassLoader classLoader, S key2, Class<?> type2) {
            try {
                Class<?> clazz = super.insert(classLoader, key2, type2);
                return clazz;
            }
            finally {
                this.expungeStaleEntries();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Class<?> findOrInsert(ClassLoader classLoader, S key2, Callable<Class<?>> builder2) {
            try {
                Class<?> clazz = super.findOrInsert(classLoader, key2, builder2);
                return clazz;
            }
            finally {
                this.expungeStaleEntries();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Class<?> findOrInsert(ClassLoader classLoader, S key2, Callable<Class<?>> builder2, Object monitor) {
            try {
                Class<?> clazz = super.findOrInsert(classLoader, key2, builder2, monitor);
                return clazz;
            }
            finally {
                this.expungeStaleEntries();
            }
        }
    }

    protected static class StorageKey
    extends WeakReference<ClassLoader> {
        private final int hashCode;

        protected StorageKey(ClassLoader classLoader, ReferenceQueue<? super ClassLoader> referenceQueue) {
            super(classLoader, referenceQueue);
            this.hashCode = System.identityHashCode(classLoader);
        }

        public int hashCode() {
            return this.hashCode;
        }

        @SuppressFBWarnings(value={"EQ_CHECK_FOR_OPERAND_NOT_COMPATIBLE_WITH_THIS"}, justification="Cross-comparison is intended")
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof LookupKey) {
                LookupKey lookupKey = (LookupKey)other;
                return this.hashCode == lookupKey.hashCode && this.get() == lookupKey.classLoader;
            }
            if (other instanceof StorageKey) {
                StorageKey storageKey = (StorageKey)other;
                return this.hashCode == storageKey.hashCode && this.get() == storageKey.get();
            }
            return false;
        }
    }

    protected static class LookupKey {
        private final ClassLoader classLoader;
        private final int hashCode;

        protected LookupKey(ClassLoader classLoader) {
            this.classLoader = classLoader;
            this.hashCode = System.identityHashCode(classLoader);
        }

        public int hashCode() {
            return this.hashCode;
        }

        @SuppressFBWarnings(value={"EQ_CHECK_FOR_OPERAND_NOT_COMPATIBLE_WITH_THIS"}, justification="Cross-comparison is intended")
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof LookupKey) {
                return this.classLoader == ((LookupKey)other).classLoader;
            }
            if (other instanceof StorageKey) {
                StorageKey storageKey = (StorageKey)other;
                return this.hashCode == storageKey.hashCode && this.classLoader == storageKey.get();
            }
            return false;
        }
    }

    public static enum Sort {
        WEAK{

            @Override
            protected Reference<Class<?>> wrap(Class<?> type2) {
                return new WeakReference(type2);
            }
        }
        ,
        SOFT{

            @Override
            protected Reference<Class<?>> wrap(Class<?> type2) {
                return new SoftReference(type2);
            }
        };


        protected abstract Reference<Class<?>> wrap(Class<?> var1);
    }
}

