/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import org.assertj.core.api.AssertionInfo;
import org.assertj.core.error.ShouldContainCharSequence;
import org.assertj.core.error.ShouldEndWith;
import org.assertj.core.error.ShouldHaveCause;
import org.assertj.core.error.ShouldHaveCauseExactlyInstance;
import org.assertj.core.error.ShouldHaveCauseInstance;
import org.assertj.core.error.ShouldHaveMessage;
import org.assertj.core.error.ShouldHaveMessageMatchingRegex;
import org.assertj.core.error.ShouldHaveNoCause;
import org.assertj.core.error.ShouldHaveNoSuppressedExceptions;
import org.assertj.core.error.ShouldHaveRootCauseExactlyInstance;
import org.assertj.core.error.ShouldHaveRootCauseInstance;
import org.assertj.core.error.ShouldHaveSuppressedException;
import org.assertj.core.error.ShouldStartWith;
import org.assertj.core.internal.CommonValidations;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Objects;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.VisibleForTesting;

public class Throwables {
    private static final Throwables INSTANCE = new Throwables();
    @VisibleForTesting
    Failures failures = Failures.instance();

    public static Throwables instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    Throwables() {
    }

    public void assertHasMessage(AssertionInfo info2, Throwable actual, String expectedMessage) {
        Throwables.assertNotNull(info2, actual);
        if (org.assertj.core.util.Objects.areEqual(actual.getMessage(), expectedMessage)) {
            return;
        }
        throw this.failures.failure(info2, ShouldHaveMessage.shouldHaveMessage(actual, expectedMessage), actual.getMessage(), expectedMessage);
    }

    public void assertHasCause(AssertionInfo info2, Throwable actual, Throwable expectedCause) {
        Throwables.assertNotNull(info2, actual);
        Throwable actualCause = actual.getCause();
        if (actualCause == expectedCause) {
            return;
        }
        if (null == expectedCause) {
            this.assertHasNoCause(info2, actual);
            return;
        }
        if (actualCause == null) {
            throw this.failures.failure(info2, ShouldHaveCause.shouldHaveCause(actualCause, expectedCause));
        }
        if (!Throwables.compareThrowable(actualCause, expectedCause)) {
            throw this.failures.failure(info2, ShouldHaveCause.shouldHaveCause(actualCause, expectedCause));
        }
    }

    public void assertHasNoCause(AssertionInfo info2, Throwable actual) {
        Throwables.assertNotNull(info2, actual);
        Throwable actualCause = actual.getCause();
        if (actualCause == null) {
            return;
        }
        throw this.failures.failure(info2, ShouldHaveNoCause.shouldHaveNoCause(actual));
    }

    public void assertHasMessageStartingWith(AssertionInfo info2, Throwable actual, String description2) {
        Throwables.assertNotNull(info2, actual);
        if (actual.getMessage() != null && actual.getMessage().startsWith(description2)) {
            return;
        }
        throw this.failures.failure(info2, ShouldStartWith.shouldStartWith(actual.getMessage(), description2));
    }

    public void assertHasMessageContaining(AssertionInfo info2, Throwable actual, String description2) {
        Throwables.assertNotNull(info2, actual);
        if (actual.getMessage() != null && actual.getMessage().contains(description2)) {
            return;
        }
        throw this.failures.failure(info2, ShouldContainCharSequence.shouldContain(actual.getMessage(), description2));
    }

    public void assertHasStackTraceContaining(AssertionInfo info2, Throwable actual, String description2) {
        Throwables.assertNotNull(info2, actual);
        String stackTrace2 = org.assertj.core.util.Throwables.getStackTrace(actual);
        if (stackTrace2 != null && stackTrace2.contains(description2)) {
            return;
        }
        throw this.failures.failure(info2, ShouldContainCharSequence.shouldContain(stackTrace2, description2));
    }

    public void assertHasMessageMatching(AssertionInfo info2, Throwable actual, String regex) {
        Preconditions.checkNotNull(regex, "regex must not be null");
        Throwables.assertNotNull(info2, actual);
        if (actual.getMessage() != null && actual.getMessage().matches(regex)) {
            return;
        }
        throw this.failures.failure(info2, ShouldHaveMessageMatchingRegex.shouldHaveMessageMatchingRegex(actual, regex));
    }

    public void assertHasMessageEndingWith(AssertionInfo info2, Throwable actual, String description2) {
        Throwables.assertNotNull(info2, actual);
        if (actual.getMessage() != null && actual.getMessage().endsWith(description2)) {
            return;
        }
        throw this.failures.failure(info2, ShouldEndWith.shouldEndWith(actual.getMessage(), description2));
    }

    public void assertHasCauseInstanceOf(AssertionInfo info2, Throwable actual, Class<? extends Throwable> type2) {
        Throwables.assertNotNull(info2, actual);
        CommonValidations.checkTypeIsNotNull(type2);
        if (type2.isInstance(actual.getCause())) {
            return;
        }
        throw this.failures.failure(info2, ShouldHaveCauseInstance.shouldHaveCauseInstance(actual, type2));
    }

    public void assertHasCauseExactlyInstanceOf(AssertionInfo info2, Throwable actual, Class<? extends Throwable> type2) {
        Throwables.assertNotNull(info2, actual);
        CommonValidations.checkTypeIsNotNull(type2);
        Throwable cause = actual.getCause();
        if (cause != null && type2.equals(cause.getClass())) {
            return;
        }
        throw this.failures.failure(info2, ShouldHaveCauseExactlyInstance.shouldHaveCauseExactlyInstance(actual, type2));
    }

    public void assertHasRootCauseInstanceOf(AssertionInfo info2, Throwable actual, Class<? extends Throwable> type2) {
        Throwables.assertNotNull(info2, actual);
        CommonValidations.checkTypeIsNotNull(type2);
        if (type2.isInstance(org.assertj.core.util.Throwables.getRootCause(actual))) {
            return;
        }
        throw this.failures.failure(info2, ShouldHaveRootCauseInstance.shouldHaveRootCauseInstance(actual, type2));
    }

    public void assertHasRootCauseExactlyInstanceOf(AssertionInfo info2, Throwable actual, Class<? extends Throwable> type2) {
        Throwables.assertNotNull(info2, actual);
        CommonValidations.checkTypeIsNotNull(type2);
        Throwable rootCause = org.assertj.core.util.Throwables.getRootCause(actual);
        if (rootCause != null && type2.equals(rootCause.getClass())) {
            return;
        }
        throw this.failures.failure(info2, ShouldHaveRootCauseExactlyInstance.shouldHaveRootCauseExactlyInstance(actual, type2));
    }

    public void assertHasNoSuppressedExceptions(AssertionInfo info2, Throwable actual) {
        Throwables.assertNotNull(info2, actual);
        Throwable[] suppressed = actual.getSuppressed();
        if (suppressed.length != 0) {
            throw this.failures.failure(info2, ShouldHaveNoSuppressedExceptions.shouldHaveNoSuppressedExceptions(suppressed));
        }
    }

    public void assertHasSuppressedException(AssertionInfo info2, Throwable actual, Throwable expectedSuppressedException) {
        Throwables.assertNotNull(info2, actual);
        Preconditions.checkNotNull(expectedSuppressedException, "The expected suppressed exception should not be null");
        Throwable[] suppressed = actual.getSuppressed();
        for (int i2 = 0; i2 < suppressed.length; ++i2) {
            if (!Throwables.compareThrowable(suppressed[i2], expectedSuppressedException)) continue;
            return;
        }
        throw this.failures.failure(info2, ShouldHaveSuppressedException.shouldHaveSuppressedException(actual, expectedSuppressedException));
    }

    private static void assertNotNull(AssertionInfo info2, Throwable actual) {
        Objects.instance().assertNotNull(info2, actual);
    }

    private static boolean compareThrowable(Throwable actual, Throwable expected) {
        return org.assertj.core.util.Objects.areEqual(actual.getMessage(), expected.getMessage()) && org.assertj.core.util.Objects.areEqual(actual.getClass(), expected.getClass());
    }
}

