/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.error.ShouldBeAfter;
import org.assertj.core.error.ShouldBeAfterOrEqualsTo;
import org.assertj.core.error.ShouldBeAfterYear;
import org.assertj.core.error.ShouldBeBefore;
import org.assertj.core.error.ShouldBeBeforeOrEqualsTo;
import org.assertj.core.error.ShouldBeBeforeYear;
import org.assertj.core.error.ShouldBeBetween;
import org.assertj.core.error.ShouldBeCloseTo;
import org.assertj.core.error.ShouldBeEqualWithTimePrecision;
import org.assertj.core.error.ShouldBeInSameDay;
import org.assertj.core.error.ShouldBeInSameHour;
import org.assertj.core.error.ShouldBeInSameHourWindow;
import org.assertj.core.error.ShouldBeInSameMinute;
import org.assertj.core.error.ShouldBeInSameMinuteWindow;
import org.assertj.core.error.ShouldBeInSameMonth;
import org.assertj.core.error.ShouldBeInSameSecond;
import org.assertj.core.error.ShouldBeInSameSecondWindow;
import org.assertj.core.error.ShouldBeInSameYear;
import org.assertj.core.error.ShouldBeInTheFuture;
import org.assertj.core.error.ShouldBeInThePast;
import org.assertj.core.error.ShouldBeToday;
import org.assertj.core.error.ShouldHaveDateField;
import org.assertj.core.error.ShouldHaveSameTime;
import org.assertj.core.error.ShouldHaveTime;
import org.assertj.core.error.ShouldNotBeBetween;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Objects;
import org.assertj.core.internal.StandardComparisonStrategy;
import org.assertj.core.util.DateUtil;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.VisibleForTesting;

public class Dates {
    private static final Dates INSTANCE = new Dates();
    @VisibleForTesting
    Failures failures = Failures.instance();
    private final ComparisonStrategy comparisonStrategy;

    public static Dates instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    Dates() {
        this(StandardComparisonStrategy.instance());
    }

    public Dates(ComparisonStrategy comparisonStrategy) {
        this.comparisonStrategy = comparisonStrategy;
    }

    @VisibleForTesting
    public Comparator<?> getComparator() {
        if (this.comparisonStrategy instanceof ComparatorBasedComparisonStrategy) {
            return ((ComparatorBasedComparisonStrategy)this.comparisonStrategy).getComparator();
        }
        return null;
    }

    public void assertIsBefore(AssertionInfo info2, Date actual, Date other) {
        this.assertNotNull(info2, actual);
        Dates.dateParameterIsNotNull(other);
        if (!this.isBefore(actual, other)) {
            throw this.failures.failure(info2, ShouldBeBefore.shouldBeBefore(actual, other, this.comparisonStrategy));
        }
    }

    public void assertIsBeforeOrEqualsTo(AssertionInfo info2, Date actual, Date other) {
        this.assertNotNull(info2, actual);
        Dates.dateParameterIsNotNull(other);
        if (!this.isBeforeOrEqualTo(actual, other)) {
            throw this.failures.failure(info2, ShouldBeBeforeOrEqualsTo.shouldBeBeforeOrEqualsTo(actual, other, this.comparisonStrategy));
        }
    }

    public void assertIsAfter(AssertionInfo info2, Date actual, Date other) {
        this.assertNotNull(info2, actual);
        Dates.dateParameterIsNotNull(other);
        if (!this.isAfter(actual, other)) {
            throw this.failures.failure(info2, ShouldBeAfter.shouldBeAfter(actual, other, this.comparisonStrategy));
        }
    }

    public void assertIsAfterOrEqualsTo(AssertionInfo info2, Date actual, Date other) {
        this.assertNotNull(info2, actual);
        Dates.dateParameterIsNotNull(other);
        if (!this.isAfterOrEqualTo(actual, other)) {
            throw this.failures.failure(info2, ShouldBeAfterOrEqualsTo.shouldBeAfterOrEqualsTo(actual, other, this.comparisonStrategy));
        }
    }

    public void assertIsEqualWithPrecision(AssertionInfo info2, Date actual, Date other, TimeUnit precision) {
        this.assertNotNull(info2, actual);
        Calendar calendarActual = Calendar.getInstance();
        calendarActual.setTime(actual);
        Calendar calendarOther = Calendar.getInstance();
        calendarOther.setTime(other);
        switch (precision) {
            case DAYS: {
                calendarActual.set(7, 0);
                calendarOther.set(7, 0);
            }
            case HOURS: {
                calendarActual.set(11, 0);
                calendarOther.set(11, 0);
            }
            case MINUTES: {
                calendarActual.set(12, 0);
                calendarOther.set(12, 0);
            }
            case SECONDS: {
                calendarActual.set(13, 0);
                calendarOther.set(13, 0);
            }
            case MILLISECONDS: {
                calendarActual.set(14, 0);
                calendarOther.set(14, 0);
            }
            case MICROSECONDS: {
                break;
            }
        }
        if (calendarActual.compareTo(calendarOther) != 0) {
            throw this.failures.failure(info2, ShouldBeEqualWithTimePrecision.shouldBeEqual(actual, other, precision));
        }
    }

    public void assertIsBetween(AssertionInfo info2, Date actual, Date start2, Date end2, boolean inclusiveStart, boolean inclusiveEnd) {
        if (!this.actualIsBetweenGivenPeriod(info2, actual, start2, end2, inclusiveStart, inclusiveEnd)) {
            throw this.failures.failure(info2, ShouldBeBetween.shouldBeBetween(actual, start2, end2, inclusiveStart, inclusiveEnd, this.comparisonStrategy));
        }
    }

    private boolean actualIsBetweenGivenPeriod(AssertionInfo info2, Date actual, Date start2, Date end2, boolean inclusiveStart, boolean inclusiveEnd) {
        this.assertNotNull(info2, actual);
        Dates.startDateParameterIsNotNull(start2);
        Dates.endDateParameterIsNotNull(end2);
        boolean checkLowerBoundaryPeriod = inclusiveStart ? this.isAfterOrEqualTo(actual, start2) : this.isAfter(actual, start2);
        boolean checkUpperBoundaryPeriod = inclusiveEnd ? this.isBeforeOrEqualTo(actual, end2) : this.isBefore(actual, end2);
        boolean isBetweenGivenPeriod = checkLowerBoundaryPeriod && checkUpperBoundaryPeriod;
        return isBetweenGivenPeriod;
    }

    public void assertIsNotBetween(AssertionInfo info2, Date actual, Date start2, Date end2, boolean inclusiveStart, boolean inclusiveEnd) {
        if (this.actualIsBetweenGivenPeriod(info2, actual, start2, end2, inclusiveStart, inclusiveEnd)) {
            throw this.failures.failure(info2, ShouldNotBeBetween.shouldNotBeBetween(actual, start2, end2, inclusiveStart, inclusiveEnd, this.comparisonStrategy));
        }
    }

    public void assertIsInThePast(AssertionInfo info2, Date actual) {
        this.assertNotNull(info2, actual);
        if (!this.isBefore(actual, DateUtil.now())) {
            throw this.failures.failure(info2, ShouldBeInThePast.shouldBeInThePast(actual, this.comparisonStrategy));
        }
    }

    public void assertIsToday(AssertionInfo info2, Date actual) {
        this.assertNotNull(info2, actual);
        Date todayWithoutTime = DateUtil.truncateTime(DateUtil.now());
        Date actualWithoutTime = DateUtil.truncateTime(actual);
        if (!this.areEqual(actualWithoutTime, todayWithoutTime)) {
            throw this.failures.failure(info2, ShouldBeToday.shouldBeToday(actual, this.comparisonStrategy));
        }
    }

    public void assertIsInTheFuture(AssertionInfo info2, Date actual) {
        this.assertNotNull(info2, actual);
        if (!this.isAfter(actual, DateUtil.now())) {
            throw this.failures.failure(info2, ShouldBeInTheFuture.shouldBeInTheFuture(actual, this.comparisonStrategy));
        }
    }

    public void assertIsBeforeYear(AssertionInfo info2, Date actual, int year2) {
        this.assertNotNull(info2, actual);
        if (DateUtil.yearOf(actual) >= year2) {
            throw this.failures.failure(info2, ShouldBeBeforeYear.shouldBeBeforeYear(actual, year2));
        }
    }

    public void assertIsAfterYear(AssertionInfo info2, Date actual, int year2) {
        this.assertNotNull(info2, actual);
        if (DateUtil.yearOf(actual) <= year2) {
            throw this.failures.failure(info2, ShouldBeAfterYear.shouldBeAfterYear(actual, year2));
        }
    }

    public void assertHasYear(AssertionInfo info2, Date actual, int year2) {
        this.assertNotNull(info2, actual);
        if (DateUtil.yearOf(actual) != year2) {
            throw this.failures.failure(info2, ShouldHaveDateField.shouldHaveDateField(actual, "year", year2));
        }
    }

    public void assertHasMonth(AssertionInfo info2, Date actual, int month) {
        this.assertNotNull(info2, actual);
        if (DateUtil.monthOf(actual) != month) {
            throw this.failures.failure(info2, ShouldHaveDateField.shouldHaveDateField(actual, "month", month));
        }
    }

    public void assertHasDayOfMonth(AssertionInfo info2, Date actual, int dayOfMonth) {
        this.assertNotNull(info2, actual);
        if (DateUtil.dayOfMonthOf(actual) != dayOfMonth) {
            throw this.failures.failure(info2, ShouldHaveDateField.shouldHaveDateField(actual, "day of month", dayOfMonth));
        }
    }

    public void assertHasDayOfWeek(AssertionInfo info2, Date actual, int dayOfWeek) {
        this.assertNotNull(info2, actual);
        if (DateUtil.dayOfWeekOf(actual) != dayOfWeek) {
            throw this.failures.failure(info2, ShouldHaveDateField.shouldHaveDateField(actual, "day of week", dayOfWeek));
        }
    }

    public void assertHasHourOfDay(AssertionInfo info2, Date actual, int hourOfDay) {
        this.assertNotNull(info2, actual);
        if (DateUtil.hourOfDayOf(actual) != hourOfDay) {
            throw this.failures.failure(info2, ShouldHaveDateField.shouldHaveDateField(actual, "hour", hourOfDay));
        }
    }

    public void assertHasMinute(AssertionInfo info2, Date actual, int minute2) {
        this.assertNotNull(info2, actual);
        if (DateUtil.minuteOf(actual) != minute2) {
            throw this.failures.failure(info2, ShouldHaveDateField.shouldHaveDateField(actual, "minute", minute2));
        }
    }

    public void assertHasSecond(AssertionInfo info2, Date actual, int second2) {
        this.assertNotNull(info2, actual);
        if (DateUtil.secondOf(actual) != second2) {
            throw this.failures.failure(info2, ShouldHaveDateField.shouldHaveDateField(actual, "second", second2));
        }
    }

    public void assertHasMillisecond(AssertionInfo info2, Date actual, int millisecond) {
        this.assertNotNull(info2, actual);
        if (DateUtil.millisecondOf(actual) != millisecond) {
            throw this.failures.failure(info2, ShouldHaveDateField.shouldHaveDateField(actual, "millisecond", millisecond));
        }
    }

    public void assertIsInSameYearAs(AssertionInfo info2, Date actual, Date other) {
        this.assertNotNull(info2, actual);
        Dates.dateParameterIsNotNull(other);
        if (!Dates.areInSameYear(actual, other)) {
            throw this.failures.failure(info2, ShouldBeInSameYear.shouldBeInSameYear(actual, other));
        }
    }

    private static boolean areInSameYear(Date actual, Date other) {
        return DateUtil.yearOf(actual) == DateUtil.yearOf(other);
    }

    public void assertIsInSameMonthAs(AssertionInfo info2, Date actual, Date other) {
        this.assertNotNull(info2, actual);
        Dates.dateParameterIsNotNull(other);
        if (!Dates.areInSameMonth(actual, other)) {
            throw this.failures.failure(info2, ShouldBeInSameMonth.shouldBeInSameMonth(actual, other));
        }
    }

    private static boolean areInSameMonth(Date actual, Date other) {
        return Dates.areInSameYear(actual, other) && DateUtil.monthOf(actual) == DateUtil.monthOf(other);
    }

    public void assertIsInSameDayAs(AssertionInfo info2, Date actual, Date other) {
        this.assertNotNull(info2, actual);
        Dates.dateParameterIsNotNull(other);
        if (!Dates.areInSameDayOfMonth(actual, other)) {
            throw this.failures.failure(info2, ShouldBeInSameDay.shouldBeInSameDay(actual, other));
        }
    }

    private static boolean areInSameDayOfMonth(Date actual, Date other) {
        return Dates.areInSameMonth(actual, other) && DateUtil.dayOfMonthOf(actual) == DateUtil.dayOfMonthOf(other);
    }

    public void assertIsInSameHourAs(AssertionInfo info2, Date actual, Date other) {
        this.assertNotNull(info2, actual);
        Dates.dateParameterIsNotNull(other);
        if (!Dates.areInSameHour(actual, other)) {
            throw this.failures.failure(info2, ShouldBeInSameHour.shouldBeInSameHour(actual, other));
        }
    }

    public void assertIsInSameHourWindowAs(AssertionInfo info2, Date actual, Date other) {
        this.assertNotNull(info2, actual);
        Dates.dateParameterIsNotNull(other);
        if (!Dates.areInSameHourWindow(actual, other)) {
            throw this.failures.failure(info2, ShouldBeInSameHourWindow.shouldBeInSameHourWindow(actual, other));
        }
    }

    private static boolean areInSameHourWindow(Date actual, Date other) {
        return DateUtil.timeDifference(actual, other) < TimeUnit.HOURS.toMillis(1L);
    }

    private static boolean areInSameHour(Date actual, Date other) {
        return Dates.areInSameDayOfMonth(actual, other) && DateUtil.hourOfDayOf(actual) == DateUtil.hourOfDayOf(other);
    }

    public void assertIsInSameMinuteAs(AssertionInfo info2, Date actual, Date other) {
        this.assertNotNull(info2, actual);
        Dates.dateParameterIsNotNull(other);
        if (!Dates.areInSameMinute(actual, other)) {
            throw this.failures.failure(info2, ShouldBeInSameMinute.shouldBeInSameMinute(actual, other));
        }
    }

    public void assertIsInSameMinuteWindowAs(AssertionInfo info2, Date actual, Date other) {
        this.assertNotNull(info2, actual);
        Dates.dateParameterIsNotNull(other);
        if (!Dates.areInSameMinuteWindow(actual, other)) {
            throw this.failures.failure(info2, ShouldBeInSameMinuteWindow.shouldBeInSameMinuteWindow(actual, other));
        }
    }

    private static boolean areInSameMinute(Date actual, Date other) {
        return Dates.areInSameHour(actual, other) && DateUtil.minuteOf(actual) == DateUtil.minuteOf(other);
    }

    private static boolean areInSameMinuteWindow(Date actual, Date other) {
        return DateUtil.timeDifference(actual, other) < TimeUnit.MINUTES.toMillis(1L);
    }

    public void assertIsInSameSecondAs(AssertionInfo info2, Date actual, Date other) {
        this.assertNotNull(info2, actual);
        Dates.dateParameterIsNotNull(other);
        if (!Dates.areInSameSecond(actual, other)) {
            throw this.failures.failure(info2, ShouldBeInSameSecond.shouldBeInSameSecond(actual, other));
        }
    }

    public void assertIsInSameSecondWindowAs(AssertionInfo info2, Date actual, Date other) {
        this.assertNotNull(info2, actual);
        Dates.dateParameterIsNotNull(other);
        if (!Dates.areInSameSecondWindow(actual, other)) {
            throw this.failures.failure(info2, ShouldBeInSameSecondWindow.shouldBeInSameSecondWindow(actual, other));
        }
    }

    private static boolean areInSameSecondWindow(Date actual, Date other) {
        return DateUtil.timeDifference(actual, other) < TimeUnit.SECONDS.toMillis(1L);
    }

    private static boolean areInSameSecond(Date actual, Date other) {
        return Dates.areInSameMinute(actual, other) && DateUtil.secondOf(actual) == DateUtil.secondOf(other);
    }

    public void assertIsCloseTo(AssertionInfo info2, Date actual, Date other, long deltaInMilliseconds) {
        this.assertNotNull(info2, actual);
        Dates.dateParameterIsNotNull(other);
        long difference = Math.abs(actual.getTime() - other.getTime());
        if (difference > deltaInMilliseconds) {
            throw this.failures.failure(info2, ShouldBeCloseTo.shouldBeCloseTo(actual, other, deltaInMilliseconds, difference));
        }
    }

    public void assertHasTime(AssertionInfo info2, Date actual, long timestamp) {
        this.assertNotNull(info2, actual);
        if (actual.getTime() != timestamp) {
            throw this.failures.failure(info2, ShouldHaveTime.shouldHaveTime(actual, timestamp));
        }
    }

    public void assertHasSameTime(AssertionInfo info2, Date actual, Date expected) {
        this.assertNotNull(info2, actual);
        this.assertNotNull(info2, expected);
        if (actual.getTime() != expected.getTime()) {
            throw this.failures.failure(info2, ShouldHaveSameTime.shouldHaveSameTime(actual, expected));
        }
    }

    public void hasSameTimeAs(AssertionInfo info2, Date actual, Date date) {
        this.assertNotNull(info2, actual);
        Dates.dateParameterIsNotNull(date);
        this.assertHasSameTime(info2, actual, date);
    }

    private static void dateParameterIsNotNull(Date date) {
        Preconditions.checkNotNull(date, "The date to compare actual with should not be null");
    }

    private static void startDateParameterIsNotNull(Date start2) {
        Preconditions.checkNotNull(start2, "The start date of period to compare actual with should not be null");
    }

    private static void endDateParameterIsNotNull(Date end2) {
        Preconditions.checkNotNull(end2, "The end date of period to compare actual with should not be null");
    }

    private void assertNotNull(AssertionInfo info2, Date actual) {
        Objects.instance().assertNotNull(info2, actual);
    }

    private boolean isBeforeOrEqualTo(Date actual, Date other) {
        return this.comparisonStrategy.isLessThanOrEqualTo(actual, other);
    }

    private boolean areEqual(Date actual, Date other) {
        return this.comparisonStrategy.areEqual(actual, other);
    }

    private boolean isAfterOrEqualTo(Date actual, Date other) {
        return this.comparisonStrategy.isGreaterThanOrEqualTo(actual, other);
    }

    private boolean isBefore(Date actual, Date other) {
        return this.comparisonStrategy.isLessThan(actual, other);
    }

    private boolean isAfter(Date actual, Date other) {
        return this.comparisonStrategy.isGreaterThan(actual, other);
    }
}

