/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.Condition;
import org.assertj.core.error.ShouldBe;
import org.assertj.core.error.ShouldHave;
import org.assertj.core.error.ShouldNotBe;
import org.assertj.core.error.ShouldNotHave;
import org.assertj.core.error.ShouldSatisfy;
import org.assertj.core.internal.Failures;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.VisibleForTesting;

public class Conditions {
    private static final Conditions INSTANCE = new Conditions();
    @VisibleForTesting
    Failures failures = Failures.instance();

    public static Conditions instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    Conditions() {
    }

    public <T> void assertIs(AssertionInfo info2, T actual, Condition<? super T> condition) {
        this.assertIsNotNull(condition);
        if (!condition.matches(actual)) {
            throw this.failures.failure(info2, ShouldBe.shouldBe(actual, condition));
        }
    }

    public <T> void assertIsNot(AssertionInfo info2, T actual, Condition<? super T> condition) {
        this.assertIsNotNull(condition);
        if (condition.matches(actual)) {
            throw this.failures.failure(info2, ShouldNotBe.shouldNotBe(actual, condition));
        }
    }

    public <T> void assertHas(AssertionInfo info2, T actual, Condition<? super T> condition) {
        this.assertIsNotNull(condition);
        if (!condition.matches(actual)) {
            throw this.failures.failure(info2, ShouldHave.shouldHave(actual, condition));
        }
    }

    public <T> void assertDoesNotHave(AssertionInfo info2, T actual, Condition<? super T> condition) {
        this.assertIsNotNull(condition);
        if (condition.matches(actual)) {
            throw this.failures.failure(info2, ShouldNotHave.shouldNotHave(actual, condition));
        }
    }

    public <T> void assertSatisfies(AssertionInfo info2, T actual, Condition<? super T> condition) {
        this.assertIsNotNull(condition);
        if (!condition.matches(actual)) {
            throw this.failures.failure(info2, ShouldSatisfy.shouldSatisfy(actual, condition));
        }
    }

    public void assertIsNotNull(Condition<?> condition) {
        this.assertIsNotNull(condition, "The condition to evaluate should not be null", new Object[0]);
    }

    public void assertIsNotNull(Condition<?> condition, String format, Object ... args2) {
        Preconditions.checkNotNull(condition, String.format(format, args2));
    }
}

