/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.error.ClassModifierShouldBe;
import org.assertj.core.error.ShouldBeAnnotation;
import org.assertj.core.error.ShouldBeAssignableFrom;
import org.assertj.core.error.ShouldBeInterface;
import org.assertj.core.error.ShouldHaveAnnotations;
import org.assertj.core.error.ShouldHaveFields;
import org.assertj.core.error.ShouldHaveMethods;
import org.assertj.core.error.ShouldHaveNoFields;
import org.assertj.core.error.ShouldOnlyHaveFields;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Objects;
import org.assertj.core.internal.StandardComparisonStrategy;
import org.assertj.core.util.Arrays;
import org.assertj.core.util.Lists;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.Sets;

public class Classes {
    private static final Classes INSTANCE = new Classes();
    private Failures failures = Failures.instance();
    private ComparisonStrategy comparisonStrategy = StandardComparisonStrategy.instance();

    public static Classes instance() {
        return INSTANCE;
    }

    public void assertIsAssignableFrom(AssertionInfo info2, Class<?> actual, Class<?> ... others) {
        Classes.assertNotNull(info2, actual);
        Preconditions.checkArgument(!Arrays.isNullOrEmpty(others), "Expecting at least one Class to be specified", new Object[0]);
        LinkedHashSet<Class<?>> expected = Sets.newLinkedHashSet(others);
        LinkedHashSet missing = new LinkedHashSet();
        for (Class clazz : expected) {
            Classes.classParameterIsNotNull(clazz);
            if (actual.isAssignableFrom(clazz)) continue;
            missing.add(clazz);
        }
        if (!missing.isEmpty()) {
            throw this.failures.failure(info2, ShouldBeAssignableFrom.shouldBeAssignableFrom(actual, expected, missing));
        }
    }

    public void assertIsNotInterface(AssertionInfo info2, Class<?> actual) {
        Classes.assertNotNull(info2, actual);
        if (actual.isInterface()) {
            throw this.failures.failure(info2, ShouldBeInterface.shouldNotBeInterface(actual));
        }
    }

    public void assertIsInterface(AssertionInfo info2, Class<?> actual) {
        Classes.assertNotNull(info2, actual);
        if (!actual.isInterface()) {
            throw this.failures.failure(info2, ShouldBeInterface.shouldBeInterface(actual));
        }
    }

    public void assertIsNotAnnotation(AssertionInfo info2, Class<?> actual) {
        Classes.assertNotNull(info2, actual);
        if (actual.isAnnotation()) {
            throw this.failures.failure(info2, ShouldBeAnnotation.shouldNotBeAnnotation(actual));
        }
    }

    public void assertIsAnnotation(AssertionInfo info2, Class<?> actual) {
        Classes.assertNotNull(info2, actual);
        if (!actual.isAnnotation()) {
            throw this.failures.failure(info2, ShouldBeAnnotation.shouldBeAnnotation(actual));
        }
    }

    public void assertIsFinal(AssertionInfo info2, Class<?> actual) {
        Classes.assertNotNull(info2, actual);
        if (!Modifier.isFinal(actual.getModifiers())) {
            throw this.failures.failure(info2, ClassModifierShouldBe.shouldBeFinal(actual));
        }
    }

    public void assertIsPublic(AssertionInfo info2, Class<?> actual) {
        Classes.assertNotNull(info2, actual);
        if (!Modifier.isPublic(actual.getModifiers())) {
            throw this.failures.failure(info2, ClassModifierShouldBe.shouldBePublic(actual));
        }
    }

    public void assertIsProtected(AssertionInfo info2, Class<?> actual) {
        Classes.assertNotNull(info2, actual);
        if (!Modifier.isProtected(actual.getModifiers())) {
            throw this.failures.failure(info2, ClassModifierShouldBe.shouldBeProtected(actual));
        }
    }

    public void assertIsNotFinal(AssertionInfo info2, Class<?> actual) {
        Classes.assertNotNull(info2, actual);
        if (Modifier.isFinal(actual.getModifiers())) {
            throw this.failures.failure(info2, ClassModifierShouldBe.shouldNotBeFinal(actual));
        }
    }

    public void assertContainsAnnotations(AssertionInfo info2, Class<?> actual, Class<? extends Annotation> ... annotations2) {
        Classes.assertNotNull(info2, actual);
        LinkedHashSet<Class<? extends Annotation>> expected = Sets.newLinkedHashSet(annotations2);
        LinkedHashSet<Class<? extends Annotation>> missing = new LinkedHashSet<Class<? extends Annotation>>();
        for (Class clazz : expected) {
            Classes.classParameterIsNotNull(clazz);
            if (actual.getAnnotation(clazz) != null) continue;
            missing.add(clazz);
        }
        if (!missing.isEmpty()) {
            throw this.failures.failure(info2, ShouldHaveAnnotations.shouldHaveAnnotations(actual, expected, missing));
        }
    }

    public void assertHasPublicFields(AssertionInfo info2, Class<?> actual, String ... fields2) {
        Classes.assertNotNull(info2, actual);
        LinkedHashSet<String> expectedFieldNames = Sets.newLinkedHashSet(fields2);
        LinkedHashSet<String> missingFieldNames = Sets.newLinkedHashSet();
        Set<String> actualFieldNames = Classes.fieldsToName(Classes.filterSyntheticMembers((Member[])actual.getFields()));
        if (expectedFieldNames.isEmpty()) {
            if (actualFieldNames.isEmpty()) {
                return;
            }
            throw this.failures.failure(info2, ShouldHaveNoFields.shouldHaveNoPublicFields(actual, actualFieldNames));
        }
        if (Classes.noMissingElement(actualFieldNames, expectedFieldNames, missingFieldNames)) {
            return;
        }
        throw this.failures.failure(info2, ShouldHaveFields.shouldHaveFields(actual, expectedFieldNames, missingFieldNames));
    }

    public void assertHasOnlyPublicFields(AssertionInfo info2, Class<?> actual, String ... expectedFields) {
        Classes.assertNotNull(info2, actual);
        Set<String> actualFieldNames = Classes.fieldsToName(Classes.filterSyntheticMembers((Member[])actual.getFields()));
        ArrayList<String> notExpected = Lists.newArrayList(actualFieldNames);
        ArrayList<String> notFound = Lists.newArrayList(expectedFields);
        if (expectedFields.length == 0) {
            if (actualFieldNames.isEmpty()) {
                return;
            }
            throw this.failures.failure(info2, ShouldHaveNoFields.shouldHaveNoPublicFields(actual, actualFieldNames));
        }
        for (String field : expectedFields) {
            if (!this.comparisonStrategy.iterableContains(notExpected, field)) continue;
            this.comparisonStrategy.iterablesRemoveFirst(notExpected, field);
            this.comparisonStrategy.iterablesRemoveFirst(notFound, field);
        }
        if (notExpected.isEmpty() && notFound.isEmpty()) {
            return;
        }
        throw this.failures.failure(info2, ShouldOnlyHaveFields.shouldOnlyHaveFields(actual, Lists.newArrayList(expectedFields), notFound, notExpected));
    }

    private static boolean noMissingElement(Set<String> actualNames, Set<String> expectedNames, Set<String> missingNames) {
        for (String field : expectedNames) {
            if (actualNames.contains(field)) continue;
            missingNames.add(field);
        }
        return missingNames.isEmpty();
    }

    public void assertHasDeclaredFields(AssertionInfo info2, Class<?> actual, String ... fields2) {
        Classes.assertNotNull(info2, actual);
        LinkedHashSet<String> expectedFieldNames = Sets.newLinkedHashSet(fields2);
        LinkedHashSet<String> missingFieldNames = Sets.newLinkedHashSet();
        Set<String> actualFieldNames = Classes.fieldsToName(Classes.filterSyntheticMembers((Member[])actual.getDeclaredFields()));
        if (expectedFieldNames.isEmpty()) {
            if (actualFieldNames.isEmpty()) {
                return;
            }
            throw this.failures.failure(info2, ShouldHaveNoFields.shouldHaveNoDeclaredFields(actual, actualFieldNames));
        }
        if (Classes.noMissingElement(actualFieldNames, expectedFieldNames, missingFieldNames)) {
            return;
        }
        throw this.failures.failure(info2, ShouldHaveFields.shouldHaveDeclaredFields(actual, expectedFieldNames, missingFieldNames));
    }

    public void assertHasOnlyDeclaredFields(AssertionInfo info2, Class<?> actual, String ... expectedFields) {
        Classes.assertNotNull(info2, actual);
        Set<String> actualFieldNames = Classes.fieldsToName(Classes.filterSyntheticMembers((Member[])actual.getDeclaredFields()));
        ArrayList<String> notExpected = Lists.newArrayList(actualFieldNames);
        ArrayList<String> notFound = Lists.newArrayList(expectedFields);
        if (expectedFields.length == 0) {
            if (actualFieldNames.isEmpty()) {
                return;
            }
            throw this.failures.failure(info2, ShouldHaveNoFields.shouldHaveNoDeclaredFields(actual, actualFieldNames));
        }
        for (String field : expectedFields) {
            if (!this.comparisonStrategy.iterableContains(notExpected, field)) continue;
            this.comparisonStrategy.iterablesRemoveFirst(notExpected, field);
            this.comparisonStrategy.iterablesRemoveFirst(notFound, field);
        }
        if (notExpected.isEmpty() && notFound.isEmpty()) {
            return;
        }
        throw this.failures.failure(info2, ShouldOnlyHaveFields.shouldOnlyHaveDeclaredFields(actual, Lists.newArrayList(expectedFields), notFound, notExpected));
    }

    private static Set<String> fieldsToName(Set<Field> fields2) {
        return fields2.stream().map(Field::getName).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public void assertHasMethods(AssertionInfo info2, Class<?> actual, String ... methods2) {
        Classes.assertNotNull(info2, actual);
        this.doAssertHasMethods(info2, actual, Classes.filterSyntheticMembers((Member[])Classes.getAllMethods(actual)), false, methods2);
    }

    public void assertHasDeclaredMethods(AssertionInfo info2, Class<?> actual, String ... methods2) {
        Classes.assertNotNull(info2, actual);
        this.doAssertHasMethods(info2, actual, Classes.filterSyntheticMembers((Member[])actual.getDeclaredMethods()), true, methods2);
    }

    private void doAssertHasMethods(AssertionInfo info2, Class<?> actual, Set<Method> actualMethods, boolean declared, String ... expectedMethods) {
        TreeSet<String> expectedMethodNames = Sets.newTreeSet(expectedMethods);
        TreeSet<String> missingMethodNames = Sets.newTreeSet();
        SortedSet<String> actualMethodNames = Classes.methodsToName(actualMethods);
        if (expectedMethods.length == 0) {
            if (actualMethods.isEmpty()) {
                return;
            }
            throw this.failures.failure(info2, ShouldHaveMethods.shouldNotHaveMethods(actual, declared, Classes.getMethodsWithModifier(actualMethods, Modifier.methodModifiers())));
        }
        if (!Classes.noMissingElement(actualMethodNames, expectedMethodNames, missingMethodNames)) {
            throw this.failures.failure(info2, ShouldHaveMethods.shouldHaveMethods(actual, declared, expectedMethodNames, missingMethodNames));
        }
    }

    public void assertHasPublicMethods(AssertionInfo info2, Class<?> actual, String ... methods2) {
        Classes.assertNotNull(info2, actual);
        Method[] actualMethods = actual.getMethods();
        TreeSet<String> expectedMethodNames = Sets.newTreeSet(methods2);
        TreeSet<String> missingMethodNames = Sets.newTreeSet();
        Map<String, Integer> methodNamesWithModifier = Classes.methodsToNameAndModifier(actualMethods);
        if (methods2.length == 0 && Classes.hasPublicMethods(actualMethods)) {
            throw this.failures.failure(info2, ShouldHaveMethods.shouldNotHaveMethods(actual, Modifier.toString(1), false, Classes.getMethodsWithModifier(Sets.newLinkedHashSet(actualMethods), 1)));
        }
        if (!Classes.noMissingElement(methodNamesWithModifier.keySet(), expectedMethodNames, missingMethodNames)) {
            throw this.failures.failure(info2, ShouldHaveMethods.shouldHaveMethods(actual, false, expectedMethodNames, missingMethodNames));
        }
        LinkedHashMap<String, String> nonMatchingModifiers = new LinkedHashMap<String, String>();
        if (!Classes.noNonMatchingModifier(expectedMethodNames, methodNamesWithModifier, nonMatchingModifiers, 1)) {
            throw this.failures.failure(info2, ShouldHaveMethods.shouldHaveMethods(actual, false, expectedMethodNames, Modifier.toString(1), nonMatchingModifiers));
        }
    }

    private static SortedSet<String> getMethodsWithModifier(Set<Method> methods2, int modifier) {
        TreeSet<String> methodsWithModifier = Sets.newTreeSet();
        for (Method method2 : methods2) {
            if ((method2.getModifiers() & modifier) == 0) continue;
            methodsWithModifier.add(method2.getName());
        }
        return methodsWithModifier;
    }

    private static boolean noNonMatchingModifier(Set<String> expectedMethodNames, Map<String, Integer> methodsModifier, Map<String, String> nonMatchingModifiers, int modifier) {
        for (String method2 : methodsModifier.keySet()) {
            if (!expectedMethodNames.contains(method2) || (methodsModifier.get(method2) & modifier) != 0) continue;
            nonMatchingModifiers.put(method2, Modifier.toString(methodsModifier.get(method2)));
        }
        return nonMatchingModifiers.isEmpty();
    }

    private static boolean hasPublicMethods(Method[] methods2) {
        for (Method method2 : methods2) {
            if (!Modifier.isPublic(method2.getModifiers())) continue;
            return true;
        }
        return false;
    }

    private static SortedSet<String> methodsToName(Set<Method> methods2) {
        TreeSet<String> methodsName = Sets.newTreeSet();
        for (Method method2 : methods2) {
            methodsName.add(method2.getName());
        }
        return methodsName;
    }

    private static Map<String, Integer> methodsToNameAndModifier(Method[] methods2) {
        LinkedHashMap<String, Integer> methodMap = new LinkedHashMap<String, Integer>(methods2.length);
        for (Method method2 : methods2) {
            methodMap.put(method2.getName(), method2.getModifiers());
        }
        return methodMap;
    }

    private static Method[] getAllMethods(Class<?> actual) {
        LinkedHashSet<Method> allMethods = Sets.newLinkedHashSet();
        Method[] declaredMethods = actual.getDeclaredMethods();
        allMethods.addAll(Sets.newLinkedHashSet(declaredMethods));
        Class<?> superclass = actual.getSuperclass();
        if (superclass != null) {
            allMethods.addAll(Sets.newLinkedHashSet(Classes.getAllMethods(superclass)));
        }
        return allMethods.toArray(new Method[allMethods.size()]);
    }

    private static <M extends Member> Set<M> filterSyntheticMembers(M[] members2) {
        LinkedHashSet filteredMembers = Sets.newLinkedHashSet();
        for (M member : members2) {
            if (member.isSynthetic()) continue;
            filteredMembers.add(member);
        }
        return filteredMembers;
    }

    private static void assertNotNull(AssertionInfo info2, Class<?> actual) {
        Objects.instance().assertNotNull(info2, actual);
    }

    private static void classParameterIsNotNull(Class<?> clazz) {
        Preconditions.checkNotNull(clazz, "The class to compare actual with should not be null");
    }
}

