/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.groups;

import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.iterable.Extractor;
import org.assertj.core.util.IterableUtil;
import org.assertj.core.util.Lists;
import org.assertj.core.util.Streams;

public class FieldsOrPropertiesExtractor {
    public static <F, T> T[] extract(F[] objects, Extractor<? super F, T> extractor) {
        FieldsOrPropertiesExtractor.checkObjectToExtractFromIsNotNull(objects);
        List<T> result2 = FieldsOrPropertiesExtractor.extract(Lists.newArrayList(objects), extractor);
        return IterableUtil.toArray(result2);
    }

    public static <F, T> List<T> extract(Iterable<? extends F> objects, Extractor<? super F, T> extractor) {
        FieldsOrPropertiesExtractor.checkObjectToExtractFromIsNotNull(objects);
        return Streams.stream(objects).map(extractor::extract).collect(Collectors.toList());
    }

    private static void checkObjectToExtractFromIsNotNull(Object object) {
        if (object == null) {
            throw new AssertionError((Object)"Expecting actual not to be null");
        }
    }
}

