/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.extractor;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.iterable.Extractor;
import org.assertj.core.extractor.ByNameSingleExtractor;
import org.assertj.core.groups.Tuple;
import org.assertj.core.util.Preconditions;

public class ByNameMultipleExtractor<T>
implements Extractor<T, Tuple> {
    private final String[] fieldsOrProperties;

    public ByNameMultipleExtractor(String ... fieldsOrProperties) {
        this.fieldsOrProperties = fieldsOrProperties;
    }

    @Override
    public Tuple extract(T input2) {
        Preconditions.checkArgument(this.fieldsOrProperties != null, "The names of the fields/properties to read should not be null", new Object[0]);
        Preconditions.checkArgument(this.fieldsOrProperties.length > 0, "The names of the fields/properties to read should not be empty", new Object[0]);
        Preconditions.checkArgument(input2 != null, "The object to extract fields/properties from should not be null", new Object[0]);
        List<Extractor<T, Object>> extractors = this.buildExtractors();
        List<Object> values2 = this.extractValues(input2, extractors);
        return new Tuple(values2.toArray());
    }

    private List<Object> extractValues(T input2, List<Extractor<T, Object>> singleExtractors) {
        return singleExtractors.stream().map(extractor -> extractor.extract(input2)).collect(Collectors.toList());
    }

    private List<Extractor<T, Object>> buildExtractors() {
        return Arrays.stream(this.fieldsOrProperties).map(ByNameSingleExtractor::new).collect(Collectors.toList());
    }
}

