/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import org.assertj.core.description.Description;
import org.assertj.core.error.DescriptionFormatter;
import org.assertj.core.internal.AbstractComparisonStrategy;
import org.assertj.core.presentation.Representation;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.Strings;
import org.assertj.core.util.VisibleForTesting;

public class MessageFormatter {
    private static final MessageFormatter INSTANCE = new MessageFormatter();
    @VisibleForTesting
    DescriptionFormatter descriptionFormatter = DescriptionFormatter.instance();

    public static MessageFormatter instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    MessageFormatter() {
    }

    public String format(Description d, Representation p, String format, Object ... args2) {
        Preconditions.checkNotNull(format);
        Preconditions.checkNotNull(args2);
        return this.descriptionFormatter.format(d) + Strings.formatIfArgs(format, this.format(p, args2));
    }

    private Object[] format(Representation p, Object[] args2) {
        int argCount = args2.length;
        Object[] formatted = new String[argCount];
        for (int i2 = 0; i2 < argCount; ++i2) {
            formatted[i2] = this.asText(p, args2[i2]);
        }
        return formatted;
    }

    private String asText(Representation p, Object o) {
        if (o instanceof AbstractComparisonStrategy) {
            return ((AbstractComparisonStrategy)o).asText();
        }
        return p.toStringOf(o);
    }
}

