/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.assertj.core.internal.bytebuddy.implementation.bind.annotation.FieldValue;
import org.assertj.core.internal.bytebuddy.implementation.bind.annotation.RuntimeType;
import org.assertj.core.internal.bytebuddy.implementation.bind.annotation.StubValue;
import org.assertj.core.internal.bytebuddy.implementation.bind.annotation.SuperCall;
import org.assertj.core.internal.bytebuddy.implementation.bind.annotation.SuperMethod;
import org.assertj.core.internal.bytebuddy.implementation.bind.annotation.This;

public class ErrorCollector {
    public static final String FIELD_NAME = "errorCollector";
    private static final String INTERCEPT_METHOD_NAME = "intercept";
    private static final String CLASS_NAME = ErrorCollector.class.getName();
    private final List<Throwable> errors = new ArrayList<Throwable>();
    private final LastResult lastResult = new LastResult();

    @RuntimeType
    public static Object intercept(@FieldValue(value="errorCollector") ErrorCollector errorCollector, @This Object assertion, @SuperCall Callable<?> proxy2, @SuperMethod(nullIfImpossible=true) Method method2, @StubValue Object stub) throws Exception {
        try {
            Object result2 = proxy2.call();
            errorCollector.lastResult.setSuccess(true);
            return result2;
        }
        catch (AssertionError assertionError) {
            if (errorCollector.isNestedErrorCollectorProxyCall()) {
                throw assertionError;
            }
            ErrorCollector.collectAssertionError(assertionError, errorCollector);
            if (method2 != null && !method2.getReturnType().isInstance(assertion)) {
                return stub;
            }
            return assertion;
        }
    }

    protected static void collectAssertionError(AssertionError error2, ErrorCollector errorCollector) {
        errorCollector.lastResult.setSuccess(false);
        errorCollector.errors.add((Throwable)((Object)error2));
    }

    public void addError(Throwable error2) {
        this.errors.add(error2);
        this.lastResult.recordError();
    }

    public List<Throwable> errors() {
        return Collections.unmodifiableList(this.errors);
    }

    public boolean wasSuccess() {
        return this.lastResult.wasSuccess();
    }

    private boolean isNestedErrorCollectorProxyCall() {
        return ErrorCollector.countErrorCollectorProxyCalls() > 1L;
    }

    private static long countErrorCollectorProxyCalls() {
        return Arrays.stream(Thread.currentThread().getStackTrace()).filter(stackTraceElement -> CLASS_NAME.equals(stackTraceElement.getClassName()) && stackTraceElement.getMethodName().startsWith(INTERCEPT_METHOD_NAME)).count();
    }

    private static class LastResult {
        private boolean wasSuccess = true;
        private boolean errorFound = false;

        private LastResult() {
        }

        private boolean wasSuccess() {
            return this.wasSuccess;
        }

        private void recordError() {
            this.errorFound = true;
            this.wasSuccess = false;
        }

        private void setSuccess(boolean success) {
            this.errorFound |= !success;
            if (this.resolvingOutermostErrorCollectorProxyNestedCall()) {
                this.wasSuccess = !this.errorFound;
                this.errorFound = false;
            }
        }

        private boolean resolvingOutermostErrorCollectorProxyNestedCall() {
            return ErrorCollector.countErrorCollectorProxyCalls() == 1L;
        }

        public String toString() {
            return String.format("LastResult [wasSuccess=%s, errorFound=%s]", this.wasSuccess, this.errorFound);
        }
    }
}

