/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.lang.reflect.Constructor;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractIterableAssert;

public class ClassBasedNavigableIterableAssert<SELF extends ClassBasedNavigableIterableAssert<SELF, ACTUAL, ELEMENT, ELEMENT_ASSERT>, ACTUAL extends Iterable<? extends ELEMENT>, ELEMENT, ELEMENT_ASSERT extends AbstractAssert<ELEMENT_ASSERT, ELEMENT>>
extends AbstractIterableAssert<SELF, ACTUAL, ELEMENT, ELEMENT_ASSERT> {
    private Class<ELEMENT_ASSERT> assertClass;

    public ClassBasedNavigableIterableAssert(ACTUAL actual, Class<?> selfType, Class<ELEMENT_ASSERT> assertClass) {
        super(actual, selfType);
        this.assertClass = assertClass;
    }

    @Override
    protected SELF newAbstractIterableAssert(Iterable<? extends ELEMENT> iterable) {
        return (SELF)new ClassBasedNavigableIterableAssert<SELF, Iterable<? extends ELEMENT>, ELEMENT, ELEMENT_ASSERT>(iterable, ClassBasedNavigableIterableAssert.class, this.assertClass);
    }

    @Override
    public ELEMENT_ASSERT toAssert(ELEMENT value, String description2) {
        return this.buildAssert(value, description2, value.getClass());
    }

    private <V> ELEMENT_ASSERT buildAssert(V value, String description2, Class<?> clazz) {
        try {
            Constructor<?>[] declaredConstructors = this.assertClass.getDeclaredConstructors();
            for (int i2 = 0; i2 < declaredConstructors.length; ++i2) {
                Constructor<?> constructor = declaredConstructors[i2];
                if (constructor.getParameterTypes().length != 1 || !constructor.getParameterTypes()[0].isAssignableFrom(clazz)) continue;
                AbstractAssert newAssert = (AbstractAssert)constructor.newInstance(value);
                return (ELEMENT_ASSERT)newAssert.as(description2, new Object[0]);
            }
            throw new RuntimeException("Failed to find a constructor matching " + value + " class to build the expected Assert class");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to build an assert object with " + value + ": " + e.getMessage(), e);
        }
    }
}

