/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.description.Description;
import org.assertj.core.extractor.Extractors;
import org.assertj.core.groups.Tuple;
import org.assertj.core.internal.TypeComparators;
import org.assertj.core.util.CheckReturnValue;

public abstract class AbstractObjectAssert<SELF extends AbstractObjectAssert<SELF, ACTUAL>, ACTUAL>
extends AbstractAssert<SELF, ACTUAL> {
    private Map<String, Comparator<?>> comparatorByPropertyOrField = new TreeMap();
    private TypeComparators comparatorByType;

    public AbstractObjectAssert(ACTUAL actual, Class<?> selfType) {
        super(actual, selfType);
    }

    @Override
    @CheckReturnValue
    public SELF as(Description description2) {
        return (SELF)((AbstractObjectAssert)super.as(description2));
    }

    @Override
    @CheckReturnValue
    public SELF as(String description2, Object ... args2) {
        return (SELF)((AbstractObjectAssert)super.as(description2, args2));
    }

    public SELF isEqualToIgnoringNullFields(Object other) {
        this.objects.assertIsEqualToIgnoringNullFields(this.info, this.actual, other, this.comparatorByPropertyOrField, this.getComparatorsByType());
        return (SELF)((AbstractObjectAssert)this.myself);
    }

    public SELF isEqualToComparingOnlyGivenFields(Object other, String ... propertiesOrFieldsUsedInComparison) {
        this.objects.assertIsEqualToComparingOnlyGivenFields(this.info, this.actual, other, this.comparatorByPropertyOrField, this.getComparatorsByType(), propertiesOrFieldsUsedInComparison);
        return (SELF)((AbstractObjectAssert)this.myself);
    }

    public SELF isEqualToIgnoringGivenFields(Object other, String ... propertiesOrFieldsToIgnore) {
        this.objects.assertIsEqualToIgnoringGivenFields(this.info, this.actual, other, this.comparatorByPropertyOrField, this.getComparatorsByType(), propertiesOrFieldsToIgnore);
        return (SELF)((AbstractObjectAssert)this.myself);
    }

    public SELF hasNoNullFieldsOrProperties() {
        this.objects.assertHasNoNullFieldsOrPropertiesExcept(this.info, this.actual, new String[0]);
        return (SELF)((AbstractObjectAssert)this.myself);
    }

    public SELF hasNoNullFieldsOrPropertiesExcept(String ... propertiesOrFieldsToIgnore) {
        this.objects.assertHasNoNullFieldsOrPropertiesExcept(this.info, this.actual, propertiesOrFieldsToIgnore);
        return (SELF)((AbstractObjectAssert)this.myself);
    }

    public SELF isEqualToComparingFieldByField(Object other) {
        this.objects.assertIsEqualToIgnoringGivenFields(this.info, this.actual, other, this.comparatorByPropertyOrField, this.getComparatorsByType(), new String[0]);
        return (SELF)((AbstractObjectAssert)this.myself);
    }

    protected TypeComparators getComparatorsByType() {
        if (this.comparatorByType == null) {
            this.comparatorByType = TypeComparators.defaultTypeComparators();
        }
        return this.comparatorByType;
    }

    @CheckReturnValue
    public <T> SELF usingComparatorForFields(Comparator<T> comparator2, String ... propertiesOrFields) {
        for (String propertyOrField : propertiesOrFields) {
            this.comparatorByPropertyOrField.put(propertyOrField, comparator2);
        }
        return (SELF)((AbstractObjectAssert)this.myself);
    }

    @CheckReturnValue
    public <T> SELF usingComparatorForType(Comparator<? super T> comparator2, Class<T> type2) {
        this.getComparatorsByType().put(type2, comparator2);
        return (SELF)((AbstractObjectAssert)this.myself);
    }

    public SELF hasFieldOrProperty(String name) {
        this.objects.assertHasFieldOrProperty(this.info, this.actual, name);
        return (SELF)((AbstractObjectAssert)this.myself);
    }

    public SELF hasFieldOrPropertyWithValue(String name, Object value) {
        this.objects.assertHasFieldOrPropertyWithValue(this.info, this.actual, name, value);
        return (SELF)((AbstractObjectAssert)this.myself);
    }

    @CheckReturnValue
    public AbstractListAssert<?, List<? extends Object>, Object, ObjectAssert<Object>> extracting(String ... propertiesOrFields) {
        Tuple values2 = Extractors.byName(propertiesOrFields).extract(this.actual);
        String extractedPropertiesOrFieldsDescription = Extractors.extractedDescriptionOf(propertiesOrFields);
        String description2 = Description.mostRelevantDescription(this.info.description(), extractedPropertiesOrFieldsDescription);
        return this.newListAssertInstance(values2.toList()).as(description2, new Object[0]);
    }

    @CheckReturnValue
    public AbstractListAssert<?, List<? extends Object>, Object, ObjectAssert<Object>> extracting(Function<? super ACTUAL, Object> ... extractors) {
        List values2 = Stream.of(extractors).map(extractor -> extractor.apply(this.actual)).collect(Collectors.toList());
        return this.newListAssertInstance(values2).as(this.info.description());
    }

    public AbstractObjectAssert<?, ?> extracting(Function<? super ACTUAL, ? extends Object> extractor) {
        Objects.requireNonNull(extractor, "The given java.util.function.Function extractor must not be null");
        Object extractedValue = extractor.apply(this.actual);
        return this.newObjectAssert(extractedValue).withAssertionState(this.myself);
    }

    public SELF isEqualToComparingFieldByFieldRecursively(Object other) {
        this.objects.assertIsEqualToComparingFieldByFieldRecursively(this.info, this.actual, other, this.comparatorByPropertyOrField, this.getComparatorsByType());
        return (SELF)((AbstractObjectAssert)this.myself);
    }

    public <T> SELF returns(T expected, Function<ACTUAL, T> from) {
        Objects.requireNonNull(from, "The given getter method/Function must not be null");
        this.objects.assertEqual(this.info, from.apply(this.actual), expected);
        return (SELF)((AbstractObjectAssert)this.myself);
    }

    protected AbstractObjectAssert<?, ?> newObjectAssert(Object objectUnderTest) {
        return new ObjectAssert<Object>(objectUnderTest);
    }

    @Override
    SELF withAssertionState(AbstractAssert assertInstance) {
        if (assertInstance instanceof AbstractObjectAssert) {
            AbstractObjectAssert objectAssert = (AbstractObjectAssert)assertInstance;
            return ((AbstractObjectAssert)((AbstractObjectAssert)super.withAssertionState(assertInstance)).withTypeComparator(objectAssert.comparatorByType)).withComparatorByPropertyOrField(objectAssert.comparatorByPropertyOrField);
        }
        return (SELF)((AbstractObjectAssert)super.withAssertionState(assertInstance));
    }

    SELF withTypeComparator(TypeComparators comparatorsByType) {
        this.comparatorByType = comparatorsByType;
        return (SELF)((AbstractObjectAssert)this.myself);
    }

    SELF withComparatorByPropertyOrField(Map<String, Comparator<?>> comparatorsToPropaget) {
        this.comparatorByPropertyOrField = comparatorsToPropaget;
        return (SELF)((AbstractObjectAssert)this.myself);
    }
}

