/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation.bytecode;

import java.util.Arrays;
import java.util.Collection;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.implementation.bytecode.StackManipulation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum StackSize {
    ZERO(0),
    SINGLE(1),
    DOUBLE(2);

    private final int size;

    private StackSize(int size2) {
        this.size = size2;
    }

    public static StackSize of(Class<?> type2) {
        if (type2 == Void.TYPE) {
            return ZERO;
        }
        if (type2 == Double.TYPE || type2 == Long.TYPE) {
            return DOUBLE;
        }
        return SINGLE;
    }

    public static StackSize of(int size2) {
        switch (size2) {
            case 0: {
                return ZERO;
            }
            case 1: {
                return SINGLE;
            }
            case 2: {
                return DOUBLE;
            }
        }
        throw new IllegalArgumentException("Unexpected stack size value: " + size2);
    }

    public static int of(TypeDefinition ... typeDefinition) {
        return StackSize.of(Arrays.asList(typeDefinition));
    }

    public static int of(Collection<? extends TypeDefinition> typeDefinitions) {
        int size2 = 0;
        for (TypeDefinition typeDefinition : typeDefinitions) {
            size2 += typeDefinition.getStackSize().getSize();
        }
        return size2;
    }

    public int getSize() {
        return this.size;
    }

    public StackManipulation.Size toIncreasingSize() {
        return new StackManipulation.Size(this.getSize(), this.getSize());
    }

    public StackManipulation.Size toDecreasingSize() {
        return new StackManipulation.Size(-1 * this.getSize(), 0);
    }

    public StackSize maximum(StackSize stackSize) {
        switch (this) {
            case ZERO: {
                return stackSize;
            }
            case SINGLE: {
                switch (stackSize) {
                    case DOUBLE: {
                        return stackSize;
                    }
                    case SINGLE: 
                    case ZERO: {
                        return this;
                    }
                }
                throw new AssertionError();
            }
            case DOUBLE: {
                return this;
            }
        }
        throw new AssertionError();
    }
}

