/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.repackaged.net.bytebuddy.implementation.bytecode.assign.primitive;

import kotlinx.coroutines.repackaged.net.bytebuddy.build.HashCodeAndEqualsPlugin;
import kotlinx.coroutines.repackaged.net.bytebuddy.description.type.TypeDescription;
import kotlinx.coroutines.repackaged.net.bytebuddy.implementation.bytecode.Removal;
import kotlinx.coroutines.repackaged.net.bytebuddy.implementation.bytecode.StackManipulation;
import kotlinx.coroutines.repackaged.net.bytebuddy.implementation.bytecode.assign.Assigner;
import kotlinx.coroutines.repackaged.net.bytebuddy.implementation.bytecode.constant.DefaultValue;

@HashCodeAndEqualsPlugin.Enhance
public class VoidAwareAssigner
implements Assigner {
    private final Assigner chained;

    public VoidAwareAssigner(Assigner chained) {
        this.chained = chained;
    }

    public StackManipulation assign(TypeDescription.Generic source2, TypeDescription.Generic target, Assigner.Typing typing) {
        if (source2.represents(Void.TYPE) && target.represents(Void.TYPE)) {
            return StackManipulation.Trivial.INSTANCE;
        }
        if (source2.represents(Void.TYPE)) {
            return typing.isDynamic() ? DefaultValue.of(target) : StackManipulation.Illegal.INSTANCE;
        }
        if (target.represents(Void.TYPE)) {
            return Removal.of(source2);
        }
        return this.chained.assign(source2, target, typing);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return this.chained.equals(((VoidAwareAssigner)object).chained);
    }

    public int hashCode() {
        return 17 * 31 + this.chained.hashCode();
    }
}

