/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.xml;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.util.internal.ObjectUtil;
import java.util.List;

public class XmlFrameDecoder
extends ByteToMessageDecoder {
    private final int maxFrameLength;

    public XmlFrameDecoder(int maxFrameLength) {
        this.maxFrameLength = ObjectUtil.checkPositive(maxFrameLength, "maxFrameLength");
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out2) throws Exception {
        boolean openingBracketFound = false;
        boolean atLeastOneXmlElementFound = false;
        boolean inCDATASection = false;
        long openBracketsCount = 0L;
        int length = 0;
        int leadingWhiteSpaceCount = 0;
        int bufferLength = in.writerIndex();
        if (bufferLength > this.maxFrameLength) {
            in.skipBytes(in.readableBytes());
            this.fail(bufferLength);
            return;
        }
        block0: for (int i2 = in.readerIndex(); i2 < bufferLength; ++i2) {
            byte readByte2 = in.getByte(i2);
            if (!openingBracketFound && Character.isWhitespace(readByte2)) {
                ++leadingWhiteSpaceCount;
                continue;
            }
            if (!openingBracketFound && readByte2 != 60) {
                XmlFrameDecoder.fail(ctx);
                in.skipBytes(in.readableBytes());
                return;
            }
            if (!inCDATASection && readByte2 == 60) {
                openingBracketFound = true;
                if (i2 >= bufferLength - 1) continue;
                byte peekAheadByte = in.getByte(i2 + 1);
                if (peekAheadByte == 47) {
                    for (int peekFurtherAheadIndex = i2 + 2; peekFurtherAheadIndex <= bufferLength - 1; ++peekFurtherAheadIndex) {
                        if (in.getByte(peekFurtherAheadIndex) != 62) continue;
                        --openBracketsCount;
                        continue block0;
                    }
                    continue;
                }
                if (XmlFrameDecoder.isValidStartCharForXmlElement(peekAheadByte)) {
                    atLeastOneXmlElementFound = true;
                    ++openBracketsCount;
                    continue;
                }
                if (peekAheadByte == 33) {
                    if (XmlFrameDecoder.isCommentBlockStart(in, i2)) {
                        ++openBracketsCount;
                        continue;
                    }
                    if (!XmlFrameDecoder.isCDATABlockStart(in, i2)) continue;
                    ++openBracketsCount;
                    inCDATASection = true;
                    continue;
                }
                if (peekAheadByte != 63) continue;
                ++openBracketsCount;
                continue;
            }
            if (!inCDATASection && readByte2 == 47) {
                if (i2 >= bufferLength - 1 || in.getByte(i2 + 1) != 62) continue;
                --openBracketsCount;
                continue;
            }
            if (readByte2 != 62) continue;
            length = i2 + 1;
            if (i2 - 1 > -1) {
                byte peekBehindByte = in.getByte(i2 - 1);
                if (!inCDATASection) {
                    if (peekBehindByte == 63) {
                        --openBracketsCount;
                    } else if (peekBehindByte == 45 && i2 - 2 > -1 && in.getByte(i2 - 2) == 45) {
                        --openBracketsCount;
                    }
                } else if (peekBehindByte == 93 && i2 - 2 > -1 && in.getByte(i2 - 2) == 93) {
                    --openBracketsCount;
                    inCDATASection = false;
                }
            }
            if (atLeastOneXmlElementFound && openBracketsCount == 0L) break;
        }
        int readerIndex = in.readerIndex();
        int xmlElementLength = length - readerIndex;
        if (openBracketsCount == 0L && xmlElementLength > 0) {
            if (readerIndex + xmlElementLength >= bufferLength) {
                xmlElementLength = in.readableBytes();
            }
            ByteBuf frame = XmlFrameDecoder.extractFrame(in, readerIndex + leadingWhiteSpaceCount, xmlElementLength - leadingWhiteSpaceCount);
            in.skipBytes(xmlElementLength);
            out2.add(frame);
        }
    }

    private void fail(long frameLength) {
        if (frameLength > 0L) {
            throw new TooLongFrameException("frame length exceeds " + this.maxFrameLength + ": " + frameLength + " - discarded");
        }
        throw new TooLongFrameException("frame length exceeds " + this.maxFrameLength + " - discarding");
    }

    private static void fail(ChannelHandlerContext ctx) {
        ctx.fireExceptionCaught(new CorruptedFrameException("frame contains content before the xml starts"));
    }

    private static ByteBuf extractFrame(ByteBuf buffer, int index, int length) {
        return buffer.copy(index, length);
    }

    private static boolean isValidStartCharForXmlElement(byte b) {
        return b >= 97 && b <= 122 || b >= 65 && b <= 90 || b == 58 || b == 95;
    }

    private static boolean isCommentBlockStart(ByteBuf in, int i2) {
        return i2 < in.writerIndex() - 3 && in.getByte(i2 + 2) == 45 && in.getByte(i2 + 3) == 45;
    }

    private static boolean isCDATABlockStart(ByteBuf in, int i2) {
        return i2 < in.writerIndex() - 8 && in.getByte(i2 + 2) == 91 && in.getByte(i2 + 3) == 67 && in.getByte(i2 + 4) == 68 && in.getByte(i2 + 5) == 65 && in.getByte(i2 + 6) == 84 && in.getByte(i2 + 7) == 65 && in.getByte(i2 + 8) == 91;
    }
}

