/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.address;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import java.net.SocketAddress;

public abstract class DynamicAddressConnectHandler
extends ChannelOutboundHandlerAdapter {
    @Override
    public final void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress2, SocketAddress localAddress2, ChannelPromise promise) {
        SocketAddress local2;
        SocketAddress remote;
        try {
            remote = this.remoteAddress(remoteAddress2, localAddress2);
            local2 = this.localAddress(remoteAddress2, localAddress2);
        }
        catch (Exception e) {
            promise.setFailure(e);
            return;
        }
        ctx.connect(remote, local2, promise).addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) {
                if (future.isSuccess()) {
                    future.channel().pipeline().remove(DynamicAddressConnectHandler.this);
                }
            }
        });
    }

    protected SocketAddress localAddress(SocketAddress remoteAddress2, SocketAddress localAddress2) throws Exception {
        return localAddress2;
    }

    protected SocketAddress remoteAddress(SocketAddress remoteAddress2, SocketAddress localAddress2) throws Exception {
        return remoteAddress2;
    }
}

