/*
 * Decompiled with CFR 0.152.
 */
package io.mockk.impl.instantiation;

import io.mockk.InternalPlatformDsl;
import io.mockk.MockKException;
import io.mockk.MockKGateway;
import io.mockk.impl.InternalPlatform;
import io.mockk.impl.instantiation.JvmMockFactoryHelper;
import io.mockk.impl.instantiation.RefCounterMap;
import io.mockk.impl.log.Logger;
import io.mockk.impl.stub.MockType;
import io.mockk.impl.stub.SpyKStub;
import io.mockk.impl.stub.Stub;
import io.mockk.impl.stub.StubGatewayAccess;
import io.mockk.impl.stub.StubRepository;
import io.mockk.proxy.Cancelable;
import io.mockk.proxy.MockKAgentException;
import io.mockk.proxy.MockKStaticProxyMaker;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\u0014\u001a\u00020\u00152\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00150\u001b2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001e"}, d2={"Lio/mockk/impl/instantiation/JvmStaticMockFactory;", "Lio/mockk/MockKGateway$StaticMockFactory;", "proxyMaker", "Lio/mockk/proxy/MockKStaticProxyMaker;", "stubRepository", "Lio/mockk/impl/stub/StubRepository;", "gatewayAccess", "Lio/mockk/impl/stub/StubGatewayAccess;", "(Lio/mockk/proxy/MockKStaticProxyMaker;Lio/mockk/impl/stub/StubRepository;Lio/mockk/impl/stub/StubGatewayAccess;)V", "getGatewayAccess", "()Lio/mockk/impl/stub/StubGatewayAccess;", "getProxyMaker", "()Lio/mockk/proxy/MockKStaticProxyMaker;", "refCntMap", "Lio/mockk/impl/instantiation/RefCounterMap;", "Lkotlin/reflect/KClass;", "getRefCntMap", "()Lio/mockk/impl/instantiation/RefCounterMap;", "getStubRepository", "()Lio/mockk/impl/stub/StubRepository;", "clear", "", "type", "options", "Lio/mockk/MockKGateway$ClearOptions;", "clearAll", "staticMockk", "Lkotlin/Function0;", "cls", "Companion", "mockk"})
@SourceDebugExtension(value={"SMAP\nJvmStaticMockFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmStaticMockFactory.kt\nio/mockk/impl/instantiation/JvmStaticMockFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Logger.kt\nio/mockk/impl/log/Logger$Companion\n*L\n1#1,79:1\n1855#2,2:80\n19#3:82\n*S KotlinDebug\n*F\n+ 1 JvmStaticMockFactory.kt\nio/mockk/impl/instantiation/JvmStaticMockFactory\n*L\n72#1:80,2\n76#1:82\n*E\n"})
public final class JvmStaticMockFactory
implements MockKGateway.StaticMockFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MockKStaticProxyMaker proxyMaker;
    @NotNull
    private final StubRepository stubRepository;
    @NotNull
    private final StubGatewayAccess gatewayAccess;
    @NotNull
    private final RefCounterMap<KClass<?>> refCntMap;
    @NotNull
    private static final Logger log;

    public JvmStaticMockFactory(@NotNull MockKStaticProxyMaker proxyMaker, @NotNull StubRepository stubRepository, @NotNull StubGatewayAccess gatewayAccess2) {
        Intrinsics.checkNotNullParameter(proxyMaker, "proxyMaker");
        Intrinsics.checkNotNullParameter(stubRepository, "stubRepository");
        Intrinsics.checkNotNullParameter(gatewayAccess2, "gatewayAccess");
        this.proxyMaker = proxyMaker;
        this.stubRepository = stubRepository;
        this.gatewayAccess = gatewayAccess2;
        this.refCntMap = new RefCounterMap();
    }

    @NotNull
    public final MockKStaticProxyMaker getProxyMaker() {
        return this.proxyMaker;
    }

    @NotNull
    public final StubRepository getStubRepository() {
        return this.stubRepository;
    }

    @NotNull
    public final StubGatewayAccess getGatewayAccess() {
        return this.gatewayAccess;
    }

    @NotNull
    public final RefCounterMap<KClass<?>> getRefCntMap() {
        return this.refCntMap;
    }

    @Override
    @NotNull
    public Function0<Unit> staticMockk(@NotNull KClass<?> cls) {
        Intrinsics.checkNotNullParameter(cls, "cls");
        if (this.refCntMap.incrementRefCnt(cls)) {
            Cancelable<Class<?>> cancelable;
            log.debug(new Function0<String>(cls){
                final /* synthetic */ KClass<?> $cls;
                {
                    this.$cls = $cls;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Creating static mockk for " + InternalPlatformDsl.INSTANCE.toStr(this.$cls);
                }
            });
            SpyKStub stub = new SpyKStub(cls, "static " + cls.getSimpleName(), this.gatewayAccess, true, MockType.STATIC);
            log.trace(new Function0<String>(cls){
                final /* synthetic */ KClass<?> $cls;
                {
                    this.$cls = $cls;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Building static proxy for " + InternalPlatformDsl.INSTANCE.toStr(this.$cls) + " hashcode=" + InternalPlatform.INSTANCE.hkd(this.$cls);
                }
            });
            try {
                cancelable = this.proxyMaker.staticProxy(JvmClassMappingKt.getJavaClass(cls), JvmMockFactoryHelper.INSTANCE.mockHandler(stub));
            }
            catch (MockKAgentException ex) {
                throw new MockKException("Failed to build static proxy", ex);
            }
            Cancelable<Class<?>> cancellation = cancelable;
            stub.setHashCodeStr(InternalPlatform.INSTANCE.hkd(JvmClassMappingKt.getJavaClass(cls)));
            stub.setDisposeRoutine(new Function0<Unit>(cancellation){

                public final void invoke() {
                    ((Cancelable)this.receiver).cancel();
                }
            });
            this.stubRepository.add(JvmClassMappingKt.getJavaClass(cls), stub);
        }
        return new Function0<Unit>(this, cls){
            final /* synthetic */ JvmStaticMockFactory this$0;
            final /* synthetic */ KClass<?> $cls;
            {
                this.this$0 = $receiver;
                this.$cls = $cls;
                super(0);
            }

            public final void invoke() {
                block1: {
                    Stub stub;
                    if (!this.this$0.getRefCntMap().decrementRefCnt(this.$cls)) break block1;
                    Stub stub2 = stub = this.this$0.getStubRepository().get(JvmClassMappingKt.getJavaClass(this.$cls));
                    if (stub2 != null) {
                        Stub stub3 = stub2;
                        KClass<?> kClass = this.$cls;
                        Stub it = stub3;
                        boolean bl = false;
                        JvmStaticMockFactory.Companion.getLog().debug(new Function0<String>(kClass){
                            final /* synthetic */ KClass<?> $cls;
                            {
                                this.$cls = $cls;
                                super(0);
                            }

                            @NotNull
                            public final String invoke() {
                                return "Disposing static mockk for " + this.$cls;
                            }
                        });
                        it.dispose();
                    }
                }
            }
        };
    }

    @Override
    public void clear(@NotNull KClass<?> type2, @NotNull MockKGateway.ClearOptions options2) {
        block0: {
            Intrinsics.checkNotNullParameter(type2, "type");
            Intrinsics.checkNotNullParameter(options2, "options");
            Stub stub = this.stubRepository.get(JvmClassMappingKt.getJavaClass(type2));
            if (stub == null) break block0;
            stub.clear(options2);
        }
    }

    @Override
    public void clearAll(@NotNull MockKGateway.ClearOptions options2) {
        Intrinsics.checkNotNullParameter(options2, "options");
        Iterable $this$forEach$iv = this.stubRepository.getAllStubs();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Stub it = (Stub)element$iv;
            boolean bl = false;
            it.clear(options2);
        }
    }

    static {
        Logger.Companion this_$iv = Logger.Companion;
        boolean $i$f$invoke = false;
        log = this_$iv.getLoggerFactory().invoke(Reflection.getOrCreateKotlinClass(JvmStaticMockFactory.class));
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lio/mockk/impl/instantiation/JvmStaticMockFactory$Companion;", "", "()V", "log", "Lio/mockk/impl/log/Logger;", "getLog", "()Lio/mockk/impl/log/Logger;", "mockk"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

