/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.util;

import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\f\n\u0002\b\u0004\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0007\u001a\f\u0010\u0004\u001a\u00020\u0001*\u00020\u0001H\u0002\u001a\f\u0010\b\u001a\u00020\t*\u00020\nH\u0002\u001a\f\u0010\u000b\u001a\u00020\t*\u00020\nH\u0002\u001a\n\u0010\f\u001a\u00020\u0001*\u00020\u0001\u001a\f\u0010\r\u001a\u00020\u0001*\u00020\u0001H\u0002\u00a8\u0006\u000e"}, d2={"combineSafe", "Ljava/io/File;", "dir", "relativePath", "dropLeadingTopDirs", "", "path", "", "isPathSeparator", "", "", "isPathSeparatorOrDot", "normalizeAndRelativize", "notRooted", "ktor-utils"})
public final class PathKt {
    @NotNull
    public static final File combineSafe(@NotNull File $this$combineSafe, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter($this$combineSafe, "<this>");
        Intrinsics.checkNotNullParameter(relativePath, "relativePath");
        return PathKt.combineSafe($this$combineSafe, new File(relativePath));
    }

    @NotNull
    public static final File normalizeAndRelativize(@NotNull File $this$normalizeAndRelativize) {
        Intrinsics.checkNotNullParameter($this$normalizeAndRelativize, "<this>");
        return PathKt.dropLeadingTopDirs(PathKt.notRooted(FilesKt.normalize($this$normalizeAndRelativize)));
    }

    private static final File combineSafe(File dir, File relativePath) {
        File normalized = PathKt.normalizeAndRelativize(relativePath);
        if (FilesKt.startsWith(normalized, "..")) {
            throw new IllegalArgumentException("Bad relative path " + relativePath);
        }
        if (!(!normalized.isAbsolute())) {
            boolean bl = false;
            String string = "Bad relative path " + relativePath;
            throw new IllegalStateException(string.toString());
        }
        return new File(dir, normalized.getPath());
    }

    private static final File notRooted(File $this$notRooted) {
        String string;
        block3: {
            if (!FilesKt.isRooted($this$notRooted)) {
                return $this$notRooted;
            }
            File current = $this$notRooted;
            while (current.getParentFile() != null) {
                File parent;
                current = parent;
            }
            String string2 = $this$notRooted.getPath();
            Intrinsics.checkNotNullExpressionValue(string2, "path");
            String $this$dropWhile$iv = StringsKt.drop(string2, current.getName().length());
            boolean $i$f$dropWhile = false;
            int n = $this$dropWhile$iv.length();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                char it = $this$dropWhile$iv.charAt(index$iv);
                boolean bl = false;
                if (it == '\\' || it == '/') continue;
                String string3 = $this$dropWhile$iv.substring(index$iv);
                string = string3;
                Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String).substring(startIndex)");
                break block3;
            }
            string = "";
        }
        String string4 = string;
        return new File(string4);
    }

    public static final int dropLeadingTopDirs(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        int startIndex = 0;
        int lastIndex = path.length() - 1;
        while (startIndex <= lastIndex) {
            char first2 = path.charAt(startIndex);
            if (PathKt.isPathSeparator(first2)) {
                ++startIndex;
                continue;
            }
            if (first2 != '.') break;
            if (startIndex == lastIndex) {
                ++startIndex;
                break;
            }
            char second2 = path.charAt(startIndex + 1);
            if (PathKt.isPathSeparator(second2)) {
                startIndex += 2;
                continue;
            }
            if (second2 != '.') break;
            if (startIndex + 2 == path.length()) {
                startIndex += 2;
                continue;
            }
            if (!PathKt.isPathSeparator(path.charAt(startIndex + 2))) break;
            startIndex += 3;
        }
        return startIndex;
    }

    private static final boolean isPathSeparator(char $this$isPathSeparator) {
        return $this$isPathSeparator == '\\' || $this$isPathSeparator == '/';
    }

    private static final boolean isPathSeparatorOrDot(char $this$isPathSeparatorOrDot) {
        return $this$isPathSeparatorOrDot == '.' || PathKt.isPathSeparator($this$isPathSeparatorOrDot);
    }

    private static final File dropLeadingTopDirs(File $this$dropLeadingTopDirs) {
        int startIndex;
        String string = $this$dropLeadingTopDirs.getPath();
        if (string == null) {
            string = "";
        }
        if ((startIndex = PathKt.dropLeadingTopDirs(string)) == 0) {
            return $this$dropLeadingTopDirs;
        }
        if (startIndex >= $this$dropLeadingTopDirs.getPath().length()) {
            return new File(".");
        }
        String string2 = $this$dropLeadingTopDirs.getPath();
        Intrinsics.checkNotNullExpressionValue(string2, "path");
        String string3 = string2.substring(startIndex);
        Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String).substring(startIndex)");
        return new File(string3);
    }
}

