/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.plugins.contentnegotiation;

import io.ktor.http.ContentType;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lio/ktor/server/plugins/contentnegotiation/ContentTypeWithQuality;", "", "contentType", "Lio/ktor/http/ContentType;", "quality", "", "(Lio/ktor/http/ContentType;D)V", "getContentType", "()Lio/ktor/http/ContentType;", "getQuality", "()D", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "ktor-server-content-negotiation"})
public final class ContentTypeWithQuality {
    @NotNull
    private final ContentType contentType;
    private final double quality;

    public ContentTypeWithQuality(@NotNull ContentType contentType2, double quality) {
        Intrinsics.checkNotNullParameter(contentType2, "contentType");
        this.contentType = contentType2;
        this.quality = quality;
        double d = this.quality;
        if (!(0.0 <= d ? d <= 1.0 : false)) {
            boolean bl = false;
            String string = "Quality should be in range [0, 1]: " + this.quality;
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ ContentTypeWithQuality(ContentType contentType2, double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            d = 1.0;
        }
        this(contentType2, d);
    }

    @NotNull
    public final ContentType getContentType() {
        return this.contentType;
    }

    public final double getQuality() {
        return this.quality;
    }

    @NotNull
    public final ContentType component1() {
        return this.contentType;
    }

    public final double component2() {
        return this.quality;
    }

    @NotNull
    public final ContentTypeWithQuality copy(@NotNull ContentType contentType2, double quality) {
        Intrinsics.checkNotNullParameter(contentType2, "contentType");
        return new ContentTypeWithQuality(contentType2, quality);
    }

    public static /* synthetic */ ContentTypeWithQuality copy$default(ContentTypeWithQuality contentTypeWithQuality, ContentType contentType2, double d, int n, Object object) {
        if ((n & 1) != 0) {
            contentType2 = contentTypeWithQuality.contentType;
        }
        if ((n & 2) != 0) {
            d = contentTypeWithQuality.quality;
        }
        return contentTypeWithQuality.copy(contentType2, d);
    }

    @NotNull
    public String toString() {
        return "ContentTypeWithQuality(contentType=" + this.contentType + ", quality=" + this.quality + ')';
    }

    public int hashCode() {
        int result2 = this.contentType.hashCode();
        result2 = result2 * 31 + Double.hashCode(this.quality);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ContentTypeWithQuality)) {
            return false;
        }
        ContentTypeWithQuality contentTypeWithQuality = (ContentTypeWithQuality)other;
        if (!Intrinsics.areEqual(this.contentType, contentTypeWithQuality.contentType)) {
            return false;
        }
        return Double.compare(this.quality, contentTypeWithQuality.quality) == 0;
    }
}

