/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.http.content;

import io.ktor.http.CodecsKt;
import io.ktor.http.ContentType;
import io.ktor.http.content.OutgoingContent;
import io.ktor.http.content.URIFileContent;
import io.ktor.server.application.ApplicationCall;
import io.ktor.server.http.content.JarFileContent;
import io.ktor.server.http.content.LocalFileContent;
import io.ktor.server.http.content.StaticContentResolutionKt;
import io.ktor.server.util.PathsKt;
import io.ktor.util.InternalAPI;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a.\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0002\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\tH\u0007\u001a\f\u0010\u000b\u001a\u00020\u0003*\u00020\u0003H\u0002\u001a@\u0010\f\u001a\u0004\u0018\u00010\u0005*\u00020\r2\u0006\u0010\u0007\u001a\u00020\u00032\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u000f\u001a\u00020\u00102\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\t\u00a8\u0006\u0011"}, d2={"findContainingJarFile", "Ljava/io/File;", "url", "", "resourceClasspathResource", "Lio/ktor/http/content/OutgoingContent;", "Ljava/net/URL;", "path", "mimeResolve", "Lkotlin/Function1;", "Lio/ktor/http/ContentType;", "extension", "resolveResource", "Lio/ktor/server/application/ApplicationCall;", "resourcePackage", "classLoader", "Ljava/lang/ClassLoader;", "ktor-server-core"})
public final class StaticContentResolutionKt {
    @Nullable
    public static final OutgoingContent resolveResource(@NotNull ApplicationCall $this$resolveResource, @NotNull String path, @Nullable String resourcePackage, @NotNull ClassLoader classLoader, @NotNull Function1<? super String, ContentType> mimeResolve) {
        Intrinsics.checkNotNullParameter($this$resolveResource, "<this>");
        Intrinsics.checkNotNullParameter(path, "path");
        Intrinsics.checkNotNullParameter(classLoader, "classLoader");
        Intrinsics.checkNotNullParameter(mimeResolve, "mimeResolve");
        if (StringsKt.endsWith$default(path, "/", false, 2, null) || StringsKt.endsWith$default(path, "\\", false, 2, null)) {
            return null;
        }
        String string = resourcePackage;
        if (string == null) {
            string = "";
        }
        Object object = new char[]{'.', '/', '\\'};
        Collection collection = StringsKt.split$default((CharSequence)string, object, false, 0, 6, null);
        object = new char[]{'/', '\\'};
        String normalizedPath = CollectionsKt.joinToString$default(PathsKt.normalizePathComponents(CollectionsKt.plus(collection, (Iterable)StringsKt.split$default((CharSequence)path, object, false, 0, 6, null))), "/", null, null, 0, null, null, 62, null);
        Enumeration<URL> enumeration = classLoader.getResources(normalizedPath);
        Intrinsics.checkNotNullExpressionValue(enumeration, "classLoader.getResources(normalizedPath)");
        object = SequencesKt.asSequence(CollectionsKt.iterator(enumeration)).iterator();
        while (object.hasNext()) {
            URL url2 = (URL)object.next();
            Intrinsics.checkNotNullExpressionValue(url2, "url");
            OutgoingContent outgoingContent = StaticContentResolutionKt.resourceClasspathResource(url2, normalizedPath, mimeResolve);
            if (outgoingContent == null) continue;
            OutgoingContent content2 = outgoingContent;
            boolean bl = false;
            return content2;
        }
        return null;
    }

    public static /* synthetic */ OutgoingContent resolveResource$default(ApplicationCall applicationCall, String string, String string2, ClassLoader classLoader, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            classLoader = applicationCall.getApplication().getEnvironment().getClassLoader();
        }
        if ((n & 8) != 0) {
            function1 = resolveResource.1.INSTANCE;
        }
        return StaticContentResolutionKt.resolveResource(applicationCall, string, string2, classLoader, function1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @InternalAPI
    @Nullable
    public static final OutgoingContent resourceClasspathResource(@NotNull URL url2, @NotNull String path, @NotNull Function1<? super String, ContentType> mimeResolve) {
        Intrinsics.checkNotNullParameter(url2, "url");
        Intrinsics.checkNotNullParameter(path, "path");
        Intrinsics.checkNotNullParameter(mimeResolve, "mimeResolve");
        String string = url2.getProtocol();
        if (string == null) return null;
        int n = -1;
        switch (string.hashCode()) {
            case 3143036: {
                if (string.equals("file")) {
                    n = 1;
                }
                break;
            }
            case 104987: {
                if (string.equals("jar")) {
                    n = 2;
                }
                break;
            }
            case 105516: {
                if (string.equals("jrt")) {
                    n = 3;
                }
                break;
            }
        }
        switch (n) {
            case 1: {
                String string2 = url2.getPath();
                Intrinsics.checkNotNullExpressionValue(string2, "url.path");
                File file2 = new File(CodecsKt.decodeURLPart$default(string2, 0, 0, null, 7, null));
                OutgoingContent outgoingContent = file2.isFile() ? new LocalFileContent(file2, mimeResolve.invoke(FilesKt.getExtension(file2))) : null;
                return outgoingContent;
            }
            case 2: {
                JarFileContent jarFileContent;
                if (StringsKt.endsWith$default(path, "/", false, 2, null)) {
                    jarFileContent = null;
                } else {
                    String string3 = url2.toString();
                    Intrinsics.checkNotNullExpressionValue(string3, "url.toString()");
                    File zipFile = StaticContentResolutionKt.findContainingJarFile(string3);
                    String string4 = url2.getPath();
                    Intrinsics.checkNotNullExpressionValue(string4, "url.path");
                    JarFileContent content2 = new JarFileContent(zipFile, path, mimeResolve.invoke(StaticContentResolutionKt.extension(string4)));
                    jarFileContent = content2.isFile() ? content2 : null;
                }
                OutgoingContent outgoingContent = jarFileContent;
                return outgoingContent;
            }
            case 3: {
                String string5 = url2.getPath();
                Intrinsics.checkNotNullExpressionValue(string5, "url.path");
                OutgoingContent outgoingContent = new URIFileContent(url2, mimeResolve.invoke(StaticContentResolutionKt.extension(string5)));
                return outgoingContent;
            }
            default: {
                return null;
            }
        }
    }

    @NotNull
    public static final File findContainingJarFile(@NotNull String url2) {
        Intrinsics.checkNotNullParameter(url2, "url");
        if (StringsKt.startsWith$default(url2, "jar:file:", false, 2, null)) {
            int jarPathSeparator = StringsKt.indexOf$default((CharSequence)url2, "!", 9, false, 4, null);
            if (!(jarPathSeparator != -1)) {
                boolean bl = false;
                String string = "Jar path requires !/ separator but it is: " + url2;
                throw new IllegalArgumentException(string.toString());
            }
            String string = url2.substring(9, jarPathSeparator);
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String\u2026ing(startIndex, endIndex)");
            return new File(CodecsKt.decodeURLPart$default(string, 0, 0, null, 7, null));
        }
        throw new IllegalArgumentException("Only local jars are supported (jar:file:)");
    }

    private static final String extension(String $this$extension) {
        String string;
        int n;
        Integer n2 = StringsKt.lastIndexOf$default((CharSequence)$this$extension, '/', 0, false, 6, null);
        int it = ((Number)n2).intValue();
        boolean bl = false;
        Integer n3 = it != -1 ? n2 : null;
        if (n3 != null) {
            n = n3;
        } else {
            Integer n4 = StringsKt.lastIndexOf$default((CharSequence)$this$extension, '\\', 0, false, 6, null);
            int it2 = ((Number)n4).intValue();
            boolean bl2 = false;
            Integer n5 = it2 != -1 ? n4 : null;
            n = n5 != null ? n5 : 0;
        }
        int indexOfName = n;
        int indexOfDot = StringsKt.indexOf$default((CharSequence)$this$extension, '.', indexOfName, false, 4, null);
        if (indexOfDot >= 0) {
            String string2 = $this$extension.substring(indexOfDot);
            string = string2;
            Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).substring(startIndex)");
        } else {
            string = "";
        }
        return string;
    }
}

