/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http.content;

import io.ktor.http.ApplicationResponsePropertiesKt;
import io.ktor.http.HeaderValue;
import io.ktor.http.HeaderValueWithParametersKt;
import io.ktor.http.Headers;
import io.ktor.http.HeadersBuilder;
import io.ktor.http.HttpHeaderValueParserKt;
import io.ktor.http.HttpHeaders;
import io.ktor.http.content.Version;
import io.ktor.http.content.VersionCheckResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\b\u0086\b\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00052\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\u000e\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0000J\u0014\u0010\u001c\u001a\u00020\u00112\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00000\u001eJ\u0014\u0010\u001f\u001a\u00020\u00112\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00000\u001eJ\t\u0010!\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006#"}, d2={"Lio/ktor/http/content/EntityTagVersion;", "Lio/ktor/http/content/Version;", "etag", "", "weak", "", "(Ljava/lang/String;Z)V", "getEtag", "()Ljava/lang/String;", "normalized", "getWeak", "()Z", "appendHeadersTo", "", "builder", "Lio/ktor/http/HeadersBuilder;", "check", "Lio/ktor/http/content/VersionCheckResult;", "requestHeaders", "Lio/ktor/http/Headers;", "component1", "component2", "copy", "equals", "other", "", "hashCode", "", "match", "givenMatchEtags", "", "noneMatch", "givenNoneMatchEtags", "toString", "Companion", "ktor-http"})
public final class EntityTagVersion
implements Version {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String etag;
    private final boolean weak;
    @NotNull
    private final String normalized;
    @NotNull
    private static final EntityTagVersion STAR = new EntityTagVersion("*", false);

    public EntityTagVersion(@NotNull String etag, boolean weak) {
        Intrinsics.checkNotNullParameter(etag, "etag");
        this.etag = etag;
        this.weak = weak;
        this.normalized = Intrinsics.areEqual(this.etag, "*") ? this.etag : (StringsKt.startsWith$default(this.etag, "\"", false, 2, null) ? this.etag : HeaderValueWithParametersKt.quote(this.etag));
        int n = this.etag.length();
        for (int index = 0; index < n; ++index) {
            char ch = this.etag.charAt(index);
            if (Intrinsics.compare(ch, 32) > 0 && ch != '\"' || index == 0 || index == StringsKt.getLastIndex(this.etag)) continue;
            boolean bl = false;
            String string = "Character '" + ch + "' is not allowed in entity-tag.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final String getEtag() {
        return this.etag;
    }

    public final boolean getWeak() {
        return this.weak;
    }

    @Override
    @NotNull
    public VersionCheckResult check(@NotNull Headers requestHeaders2) {
        Object object;
        VersionCheckResult result2;
        String it;
        Intrinsics.checkNotNullParameter(requestHeaders2, "requestHeaders");
        Object object2 = requestHeaders2.get(HttpHeaders.INSTANCE.getIfNoneMatch());
        if (object2 != null) {
            it = object2;
            boolean bl = false;
            List<EntityTagVersion> list = Companion.parse(it);
            object2 = list;
            if (list != null) {
                Object givenNoneMatchEtags = object2;
                boolean bl2 = false;
                result2 = this.noneMatch((List<EntityTagVersion>)givenNoneMatchEtags);
                boolean bl3 = false;
                if (result2 != VersionCheckResult.OK) {
                    return result2;
                }
            }
        }
        if ((object = requestHeaders2.get(HttpHeaders.INSTANCE.getIfMatch())) != null) {
            it = object;
            boolean bl = false;
            List<EntityTagVersion> list = Companion.parse(it);
            object = list;
            if (list != null) {
                Object givenMatchEtags = object;
                boolean bl4 = false;
                result2 = this.match((List<EntityTagVersion>)givenMatchEtags);
                boolean bl5 = false;
                if (result2 != VersionCheckResult.OK) {
                    return result2;
                }
            }
        }
        return VersionCheckResult.OK;
    }

    public final boolean match(@NotNull EntityTagVersion other) {
        Intrinsics.checkNotNullParameter(other, "other");
        if (Intrinsics.areEqual(this, STAR) || Intrinsics.areEqual(other, STAR)) {
            return true;
        }
        return Intrinsics.areEqual(this.normalized, other.normalized);
    }

    @NotNull
    public final VersionCheckResult noneMatch(@NotNull List<EntityTagVersion> givenNoneMatchEtags) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter(givenNoneMatchEtags, "givenNoneMatchEtags");
            if (givenNoneMatchEtags.contains(STAR)) {
                return VersionCheckResult.OK;
            }
            Iterable $this$any$iv = givenNoneMatchEtags;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    EntityTagVersion it = (EntityTagVersion)element$iv;
                    boolean bl2 = false;
                    if (!this.match(it)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            return VersionCheckResult.NOT_MODIFIED;
        }
        return VersionCheckResult.OK;
    }

    @NotNull
    public final VersionCheckResult match(@NotNull List<EntityTagVersion> givenMatchEtags) {
        Intrinsics.checkNotNullParameter(givenMatchEtags, "givenMatchEtags");
        if (givenMatchEtags.isEmpty()) {
            return VersionCheckResult.OK;
        }
        if (givenMatchEtags.contains(STAR)) {
            return VersionCheckResult.OK;
        }
        for (EntityTagVersion given : givenMatchEtags) {
            if (!this.match(given)) continue;
            return VersionCheckResult.OK;
        }
        return VersionCheckResult.PRECONDITION_FAILED;
    }

    @Override
    public void appendHeadersTo(@NotNull HeadersBuilder builder2) {
        Intrinsics.checkNotNullParameter(builder2, "builder");
        ApplicationResponsePropertiesKt.etag(builder2, this.normalized);
    }

    @NotNull
    public final String component1() {
        return this.etag;
    }

    public final boolean component2() {
        return this.weak;
    }

    @NotNull
    public final EntityTagVersion copy(@NotNull String etag, boolean weak) {
        Intrinsics.checkNotNullParameter(etag, "etag");
        return new EntityTagVersion(etag, weak);
    }

    public static /* synthetic */ EntityTagVersion copy$default(EntityTagVersion entityTagVersion, String string, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            string = entityTagVersion.etag;
        }
        if ((n & 2) != 0) {
            bl = entityTagVersion.weak;
        }
        return entityTagVersion.copy(string, bl);
    }

    @NotNull
    public String toString() {
        return "EntityTagVersion(etag=" + this.etag + ", weak=" + this.weak + ')';
    }

    public int hashCode() {
        int result2 = this.etag.hashCode();
        int n = this.weak ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result2 = result2 * 31 + n;
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof EntityTagVersion)) {
            return false;
        }
        EntityTagVersion entityTagVersion = (EntityTagVersion)other;
        if (!Intrinsics.areEqual(this.etag, entityTagVersion.etag)) {
            return false;
        }
        return this.weak == entityTagVersion.weak;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lio/ktor/http/content/EntityTagVersion$Companion;", "", "()V", "STAR", "Lio/ktor/http/content/EntityTagVersion;", "getSTAR", "()Lio/ktor/http/content/EntityTagVersion;", "parse", "", "headerValue", "", "parseSingle", "value", "ktor-http"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EntityTagVersion getSTAR() {
            return STAR;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<EntityTagVersion> parse(@NotNull String headerValue) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(headerValue, "headerValue");
            List<HeaderValue> rawEntries = HttpHeaderValueParserKt.parseHeaderValue(headerValue);
            Iterable $this$map$iv = rawEntries;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void entry;
                HeaderValue headerValue2 = (HeaderValue)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                if (!(entry.getQuality() == 1.0)) {
                    boolean $i$a$-check-EntityTagVersion$Companion$parse$1$32 = false;
                    String $i$a$-check-EntityTagVersion$Companion$parse$1$32 = "entity-tag quality parameter is not allowed: " + entry.getQuality() + '.';
                    throw new IllegalStateException($i$a$-check-EntityTagVersion$Companion$parse$1$32.toString());
                }
                if (!entry.getParams().isEmpty()) {
                    boolean bl2 = false;
                    String string = "entity-tag parameters are not allowed: " + entry.getParams() + '.';
                    throw new IllegalStateException(string.toString());
                }
                collection.add(Companion.parseSingle(entry.getValue()));
            }
            return (List)destination$iv$iv;
        }

        @NotNull
        public final EntityTagVersion parseSingle(@NotNull String value) {
            Intrinsics.checkNotNullParameter(value, "value");
            if (Intrinsics.areEqual(value, "*")) {
                return this.getSTAR();
            }
            boolean weak = false;
            String rawEtag = null;
            if (StringsKt.startsWith$default(value, "W/", false, 2, null)) {
                weak = true;
                rawEtag = StringsKt.drop(value, 2);
            } else {
                weak = false;
                rawEtag = value;
            }
            String etag = StringsKt.startsWith$default(rawEtag, "\"", false, 2, null) ? rawEtag : HeaderValueWithParametersKt.quote(rawEtag);
            return new EntityTagVersion(etag, weak);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

