/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lio/ktor/http/HttpMethod;", "", "value", "", "(Ljava/lang/String;)V", "getValue", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "ktor-http"})
public final class HttpMethod {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String value;
    @NotNull
    private static final HttpMethod Get = new HttpMethod("GET");
    @NotNull
    private static final HttpMethod Post = new HttpMethod("POST");
    @NotNull
    private static final HttpMethod Put = new HttpMethod("PUT");
    @NotNull
    private static final HttpMethod Patch = new HttpMethod("PATCH");
    @NotNull
    private static final HttpMethod Delete = new HttpMethod("DELETE");
    @NotNull
    private static final HttpMethod Head = new HttpMethod("HEAD");
    @NotNull
    private static final HttpMethod Options = new HttpMethod("OPTIONS");
    @NotNull
    private static final List<HttpMethod> DefaultMethods;

    public HttpMethod(@NotNull String value) {
        Intrinsics.checkNotNullParameter(value, "value");
        this.value = value;
    }

    @NotNull
    public final String getValue() {
        return this.value;
    }

    @NotNull
    public final String component1() {
        return this.value;
    }

    @NotNull
    public final HttpMethod copy(@NotNull String value) {
        Intrinsics.checkNotNullParameter(value, "value");
        return new HttpMethod(value);
    }

    public static /* synthetic */ HttpMethod copy$default(HttpMethod httpMethod, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = httpMethod.value;
        }
        return httpMethod.copy(string);
    }

    @NotNull
    public String toString() {
        return "HttpMethod(value=" + this.value + ')';
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HttpMethod)) {
            return false;
        }
        HttpMethod httpMethod = (HttpMethod)other;
        return Intrinsics.areEqual(this.value, httpMethod.value);
    }

    static {
        HttpMethod[] httpMethodArray = new HttpMethod[]{Get, Post, Put, Patch, Delete, Head, Options};
        DefaultMethods = CollectionsKt.listOf(httpMethodArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0019R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\r\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0011\u0010\u000f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\nR\u0011\u0010\u0011\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\nR\u0011\u0010\u0013\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\nR\u0011\u0010\u0015\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\n\u00a8\u0006\u001a"}, d2={"Lio/ktor/http/HttpMethod$Companion;", "", "()V", "DefaultMethods", "", "Lio/ktor/http/HttpMethod;", "getDefaultMethods", "()Ljava/util/List;", "Delete", "getDelete", "()Lio/ktor/http/HttpMethod;", "Get", "getGet", "Head", "getHead", "Options", "getOptions", "Patch", "getPatch", "Post", "getPost", "Put", "getPut", "parse", "method", "", "ktor-http"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HttpMethod getGet() {
            return Get;
        }

        @NotNull
        public final HttpMethod getPost() {
            return Post;
        }

        @NotNull
        public final HttpMethod getPut() {
            return Put;
        }

        @NotNull
        public final HttpMethod getPatch() {
            return Patch;
        }

        @NotNull
        public final HttpMethod getDelete() {
            return Delete;
        }

        @NotNull
        public final HttpMethod getHead() {
            return Head;
        }

        @NotNull
        public final HttpMethod getOptions() {
            return Options;
        }

        @NotNull
        public final HttpMethod parse(@NotNull String method2) {
            Intrinsics.checkNotNullParameter(method2, "method");
            String string = method2;
            return Intrinsics.areEqual(string, this.getGet().getValue()) ? this.getGet() : (Intrinsics.areEqual(string, this.getPost().getValue()) ? this.getPost() : (Intrinsics.areEqual(string, this.getPut().getValue()) ? this.getPut() : (Intrinsics.areEqual(string, this.getPatch().getValue()) ? this.getPatch() : (Intrinsics.areEqual(string, this.getDelete().getValue()) ? this.getDelete() : (Intrinsics.areEqual(string, this.getHead().getValue()) ? this.getHead() : (Intrinsics.areEqual(string, this.getOptions().getValue()) ? this.getOptions() : new HttpMethod(method2)))))));
        }

        @NotNull
        public final List<HttpMethod> getDefaultMethods() {
            return DefaultMethods;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

