/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.client.plugins;

import io.ktor.client.plugins.HttpTimeout;
import io.ktor.client.request.HttpRequestBuilder;
import io.ktor.client.request.HttpRequestData;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u0017\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lio/ktor/client/plugins/HttpRequestTimeoutException;", "Ljava/io/IOException;", "Lio/ktor/utils/io/errors/IOException;", "request", "Lio/ktor/client/request/HttpRequestBuilder;", "(Lio/ktor/client/request/HttpRequestBuilder;)V", "Lio/ktor/client/request/HttpRequestData;", "(Lio/ktor/client/request/HttpRequestData;)V", "url", "", "timeoutMillis", "", "(Ljava/lang/String;Ljava/lang/Long;)V", "ktor-client-core"})
public final class HttpRequestTimeoutException
extends IOException {
    public HttpRequestTimeoutException(@NotNull String url2, @Nullable Long timeoutMillis) {
        Intrinsics.checkNotNullParameter(url2, "url");
        StringBuilder stringBuilder = new StringBuilder().append("Request timeout has expired [url=").append(url2).append(", request_timeout=");
        Object object = timeoutMillis;
        if (object == null) {
            object = "unknown";
        }
        super(stringBuilder.append(object).append(" ms]").toString());
    }

    public HttpRequestTimeoutException(@NotNull HttpRequestBuilder request2) {
        Intrinsics.checkNotNullParameter(request2, "request");
        HttpTimeout.HttpTimeoutCapabilityConfiguration httpTimeoutCapabilityConfiguration = (HttpTimeout.HttpTimeoutCapabilityConfiguration)request2.getCapabilityOrNull(HttpTimeout.Plugin);
        this(request2.getUrl().buildString(), httpTimeoutCapabilityConfiguration != null ? httpTimeoutCapabilityConfiguration.getRequestTimeoutMillis() : null);
    }

    public HttpRequestTimeoutException(@NotNull HttpRequestData request2) {
        Intrinsics.checkNotNullParameter(request2, "request");
        HttpTimeout.HttpTimeoutCapabilityConfiguration httpTimeoutCapabilityConfiguration = (HttpTimeout.HttpTimeoutCapabilityConfiguration)request2.getCapabilityOrNull(HttpTimeout.Plugin);
        this(request2.getUrl().toString(), httpTimeoutCapabilityConfiguration != null ? httpTimeoutCapabilityConfiguration.getRequestTimeoutMillis() : null);
    }
}

