/*
 * Decompiled with CFR 0.152.
 */
package view;

import com.sun.tools.javac.Main;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.GlobalScope;
import main.MainKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import server.Client;
import service.ImageFactory;
import view.GuiConstantsKt;
import view.StartingMenu;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0003H\u0002J\b\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u000eH\u0002J\b\u0010\u0010\u001a\u00020\u0006H\u0002J\u0006\u0010\u0011\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lview/StartScreen;", "", "frame", "Ljavax/swing/JFrame;", "(Ljavax/swing/JFrame;)V", "addButtons", "", "constraints", "Ljava/awt/GridBagConstraints;", "addLogoImage", "addTitle", "connectToServer", "container", "makeCreateButton", "Ljavax/swing/JButton;", "makeJoinButton", "setIconImage", "start", "chain-reaction"})
public final class StartScreen {
    @NotNull
    private final JFrame frame;

    public StartScreen(@NotNull JFrame frame) {
        Intrinsics.checkNotNullParameter(frame, "frame");
        this.frame = frame;
    }

    public final void start() {
        this.frame.getContentPane().removeAll();
        this.frame.repaint();
        this.frame.setTitle("chain-reaction");
        this.setIconImage();
        this.frame.getContentPane().setBackground(Color.WHITE);
        GridBagConstraints constraints = new GridBagConstraints();
        this.frame.setLayout(new GridBagLayout());
        this.addTitle(constraints);
        this.addLogoImage(constraints);
        this.addButtons(constraints);
        this.frame.setSize(1000, 600);
        this.frame.setDefaultCloseOperation(3);
        this.frame.setVisible(true);
    }

    private final void addButtons(GridBagConstraints constraints) {
        constraints.gridx = 0;
        constraints.gridy = 2;
        JButton joinButton = this.makeJoinButton();
        JButton createButton = this.makeCreateButton();
        JPanel joinCreateButtons = new JPanel(new GridLayout(1, 2));
        joinCreateButtons.setBorder(new EmptyBorder(25, 0, 0, 0));
        joinCreateButtons.setAlignmentX(0.5f);
        joinCreateButtons.add(joinButton);
        joinCreateButtons.add(GuiConstantsKt.getBIG_HORIZONTAL_DISTANCE());
        joinCreateButtons.add(createButton);
        joinCreateButtons.setBackground(Color.WHITE);
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.ipady = 20;
        this.frame.add((Component)joinCreateButtons, constraints);
    }

    private final JButton makeCreateButton() {
        JButton createButton = new JButton("Create");
        createButton.setFocusPainted(false);
        createButton.addActionListener(arg_0 -> StartScreen.makeCreateButton$lambda$0(this, arg_0));
        return createButton;
    }

    private final JButton makeJoinButton() {
        JButton joinButton = new JButton("Join");
        joinButton.setFocusPainted(false);
        joinButton.addActionListener(arg_0 -> StartScreen.makeJoinButton$lambda$1(this, arg_0));
        return joinButton;
    }

    private final void addLogoImage(GridBagConstraints constraints) {
        BufferedImage bombPicture = ImageFactory.INSTANCE.getLogoImage();
        constraints.gridy = 1;
        JLabel pictureLabel = new JLabel(new ImageIcon(bombPicture));
        this.frame.add((Component)pictureLabel, constraints);
    }

    private final void addTitle(GridBagConstraints constraints) {
        constraints.gridx = 0;
        constraints.gridy = 0;
        JLabel titel = new JLabel("Chain Reaction");
        titel.setFont(new Font("Text", 0, 40));
        this.frame.add(titel);
    }

    private final void setIconImage() {
        URL fileName = Main.class.getClassLoader().getResource("BombIcon.png");
        BufferedImage bombPictureIcon = ImageIO.read(fileName);
        this.frame.setIconImage(bombPictureIcon);
    }

    private final void connectToServer(JFrame container2) {
        Client client2 = new Client(container2);
        Client.start$default(client2, null, 1, null);
    }

    private static final void makeCreateButton$lambda$0(StartScreen this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        StartingMenu startingMenu = new StartingMenu(this$0.frame, true);
        startingMenu.start();
    }

    private static final void makeJoinButton$lambda$1(StartScreen this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        MainKt.setMainServer(null);
        BuildersKt.launch$default(GlobalScope.INSTANCE, null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, null){
            int label;
            final /* synthetic */ StartScreen this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        StartScreen.access$connectToServer(this.this$0, StartScreen.access$getFrame$p(this.this$0));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 3, null);
    }

    public static final /* synthetic */ void access$connectToServer(StartScreen $this, JFrame container2) {
        $this.connectToServer(container2);
    }

    public static final /* synthetic */ JFrame access$getFrame$p(StartScreen $this) {
        return $this.frame;
    }
}

