/*
 * Decompiled with CFR 0.152.
 */
package view;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JPanel;
import javax.swing.Timer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import service.ImageFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0006\u0010\u0015\u001a\u00020\u0012J\b\u0010\u0016\u001a\u00020\u0004H\u0002J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0014R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lview/Gif;", "Ljavax/swing/JPanel;", "Ljava/awt/event/ActionListener;", "width", "", "height", "(II)V", "currentFrame", "delay", "images", "", "Ljava/awt/image/BufferedImage;", "isConnected", "Ljava/util/concurrent/atomic/AtomicBoolean;", "timer", "Ljavax/swing/Timer;", "totalFrames", "actionPerformed", "", "e", "Ljava/awt/event/ActionEvent;", "connected", "getNextFrame", "paintComponent", "g", "Ljava/awt/Graphics;", "chain-reaction"})
public final class Gif
extends JPanel
implements ActionListener {
    private int width;
    private int height;
    @NotNull
    private final Timer timer;
    private final int delay;
    private final int totalFrames;
    private int currentFrame;
    @NotNull
    private AtomicBoolean isConnected;
    @NotNull
    private final List<BufferedImage> images;

    public Gif(int width, int height) {
        this.width = width;
        this.height = height;
        this.delay = 50;
        this.totalFrames = 24;
        this.isConnected = new AtomicBoolean(false);
        this.images = ImageFactory.INSTANCE.gifFrames(this.totalFrames);
        this.timer = new Timer(this.delay, this);
        this.timer.start();
        this.setBackground(Color.white);
    }

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter(g, "g");
        Rectangle clipBounds = g.getClipBounds();
        if (clipBounds != null && (this.width != clipBounds.width || this.height != clipBounds.height)) {
            this.width = clipBounds.width;
            this.height = clipBounds.height;
        }
        super.paintComponent(g);
        if (!this.isConnected.get()) {
            g.drawImage(this.images.get(this.currentFrame), 0, 0, this.width, this.height, this);
            this.currentFrame = this.getNextFrame();
        } else {
            g.drawImage(ImageFactory.INSTANCE.getConnectImage(), 0, 0, this.width, this.height, this);
        }
    }

    private final int getNextFrame() {
        return (this.currentFrame + 1) % this.totalFrames;
    }

    @Override
    public void actionPerformed(@NotNull ActionEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
        this.repaint();
    }

    public final void connected() {
        this.isConnected.compareAndSet(false, true);
        Thread.sleep(800L);
    }
}

