/*
 * Decompiled with CFR 0.152.
 */
package view;

import com.sun.tools.javac.Main;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import model.board.Board;
import model.board.BombToUpdate;
import model.board.Dimension;
import model.board.Game;
import model.board.Position;
import model.figure.EmptyFigure;
import model.figure.Figure;
import model.figure.Wall;
import model.player.Player;
import model.player.PlayerColor;
import org.jetbrains.annotations.NotNull;
import server.AfterDisconnect;
import server.BombsToUpdate;
import server.ClientBomb;
import server.GameEvent;
import server.GameFinish;
import server.Init;
import server.PlayerDisconnect;
import service.BombFactory;
import service.DelayerService;
import service.GameFactory;
import service.GameService;
import view.BoardCanvas;
import view.EndDialog;
import view.GuiConstantsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0013H\u0002J\"\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J2\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\b2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\b2\u0006\u0010#\u001a\u00020\u0016J\u000e\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u0012J\u000e\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\u0016J\u0018\u0010\u0010\u001a\u00020\u00132\u0006\u0010(\u001a\u00020)2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010*\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010+\u001a\u00020\u00132\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0016H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lview/BoardGraphicalUi;", "", "isMain", "", "(Z)V", "boardCanvas", "Lview/BoardCanvas;", "countLabels", "", "Ljavax/swing/JLabel;", "currentPlayerLabel", "frame", "Ljavax/swing/JFrame;", "game", "Lmodel/board/Game;", "isDrawing", "playOnClick", "Lkotlin/Function1;", "Lserver/GameEvent;", "", "addCanvasToFrame", "playerPlacedName", "", "addTitelToFrame", "bind", "createInfoText", "textPanel", "Ljavax/swing/JPanel;", "init", "dimension", "Lmodel/board/Dimension;", "walls", "Lmodel/figure/Wall;", "players", "Lmodel/player/Player;", "nameOfSender", "onFigureChanged", "gameEvent", "painLeftPlayerCounterGray", "playerName", "position", "Lmodel/board/Position;", "setIconImage", "updateInfoText", "board", "Lmodel/board/Board;", "currentName", "chain-reaction"})
@SourceDebugExtension(value={"SMAP\nBoardGraphicalUi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BoardGraphicalUi.kt\nview/BoardGraphicalUi\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,191:1\n1549#2:192\n1620#2,3:193\n1855#2,2:196\n1360#2:198\n1446#2,2:199\n1603#2,9:201\n1855#2:210\n1856#2:212\n1612#2:213\n1448#2,3:214\n1549#2:218\n1620#2,2:219\n1774#2,4:221\n1622#2:225\n1559#2:226\n1590#2,4:227\n1559#2:231\n1590#2,4:232\n1#3:211\n1#3:217\n*S KotlinDebug\n*F\n+ 1 BoardGraphicalUi.kt\nview/BoardGraphicalUi\n*L\n54#1:192\n54#1:193,3\n105#1:196,2\n133#1:198\n133#1:199,2\n134#1:201,9\n134#1:210\n134#1:212\n134#1:213\n133#1:214,3\n164#1:218\n164#1:219,2\n165#1:221,4\n164#1:225\n169#1:226\n169#1:227,4\n177#1:231\n177#1:232,4\n134#1:211\n*E\n"})
public final class BoardGraphicalUi {
    private final boolean isMain;
    private Game game;
    private BoardCanvas boardCanvas;
    private Function1<? super GameEvent, Unit> playOnClick;
    private List<? extends JLabel> countLabels;
    private JFrame frame;
    @NotNull
    private final JLabel currentPlayerLabel;
    private boolean isDrawing;

    public BoardGraphicalUi(boolean isMain) {
        this.isMain = isMain;
        this.currentPlayerLabel = new JLabel("", 0);
    }

    public final void bind(@NotNull JFrame frame, @NotNull Function1<? super GameEvent, Unit> playOnClick) {
        Intrinsics.checkNotNullParameter(frame, "frame");
        Intrinsics.checkNotNullParameter(playOnClick, "playOnClick");
        this.frame = frame;
        this.playOnClick = playOnClick;
    }

    /*
     * WARNING - void declaration
     */
    public final void init(@NotNull Dimension dimension, @NotNull List<Wall> walls, @NotNull List<? extends Player> players2, @NotNull String nameOfSender) {
        BoardCanvas boardCanvas;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(dimension, "dimension");
        Intrinsics.checkNotNullParameter(walls, "walls");
        Intrinsics.checkNotNullParameter(players2, "players");
        Intrinsics.checkNotNullParameter(nameOfSender, "nameOfSender");
        this.game = GameFactory.INSTANCE.create(dimension, walls, players2);
        JFrame jFrame = this.frame;
        if (jFrame == null) {
            Intrinsics.throwUninitializedPropertyAccessException("frame");
            jFrame = null;
        }
        jFrame.setTitle(this.isMain ? "Chain Reaction Main" : "Chain Reaction " + nameOfSender);
        JFrame jFrame2 = this.frame;
        if (jFrame2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("frame");
            jFrame2 = null;
        }
        this.setIconImage(jFrame2);
        Iterable iterable = players2;
        BoardGraphicalUi boardGraphicalUi = this;
        boolean $i$f$map = false;
        void var7_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void player;
            Player player2 = (Player)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new JLabel("Bomb counter " + player.getName() + ": 0", 0));
        }
        boardGraphicalUi.countLabels = (List)destination$iv$iv;
        JFrame jFrame3 = this.frame;
        if (jFrame3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("frame");
            jFrame3 = null;
        }
        jFrame3.setLayout(new BorderLayout(20, 15));
        this.addTitelToFrame();
        this.addCanvasToFrame(nameOfSender);
        JPanel textPanel = new JPanel(new GridLayout(players2.size() + 1, 1));
        this.createInfoText(textPanel);
        textPanel.setForeground(Color.BLACK);
        BoardCanvas boardCanvas2 = this.boardCanvas;
        if (boardCanvas2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("boardCanvas");
            boardCanvas2 = null;
        }
        if ((boardCanvas = this.boardCanvas) == null) {
            Intrinsics.throwUninitializedPropertyAccessException("boardCanvas");
            boardCanvas = null;
        }
        boardCanvas2.paint(boardCanvas.getGraphics());
        JFrame jFrame4 = this.frame;
        if (jFrame4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("frame");
            jFrame4 = null;
        }
        jFrame4.getContentPane().setBackground(GuiConstantsKt.getLABEL_BACKGROUND());
        JFrame jFrame5 = this.frame;
        if (jFrame5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("frame");
            jFrame5 = null;
        }
        jFrame5.add((Component)textPanel, "South");
        JFrame jFrame6 = this.frame;
        if (jFrame6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("frame");
            jFrame6 = null;
        }
        jFrame6.setDefaultCloseOperation(3);
        JFrame jFrame7 = this.frame;
        if (jFrame7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("frame");
            jFrame7 = null;
        }
        jFrame7.setVisible(true);
    }

    private final void setIconImage(JFrame frame) {
        URL fileName = Main.class.getClassLoader().getResource("BombIcon.png");
        BufferedImage bombPictureIcon = ImageIO.read(fileName);
        frame.setIconImage(bombPictureIcon);
    }

    private final void playOnClick(Position position, String playerPlacedName) {
        Function1<? super GameEvent, Unit> function1 = this.playOnClick;
        if (function1 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("playOnClick");
            function1 = null;
        }
        function1.invoke(new ClientBomb(position, playerPlacedName));
    }

    private final void addCanvasToFrame(String playerPlacedName) {
        BoardCanvas boardCanvas;
        Game game = this.game;
        if (game == null) {
            Intrinsics.throwUninitializedPropertyAccessException("game");
            game = null;
        }
        this.boardCanvas = new BoardCanvas(game.getBoard(), (Function1<? super Position, Unit>)new Function1<Position, Unit>(this, playerPlacedName){
            final /* synthetic */ BoardGraphicalUi this$0;
            final /* synthetic */ String $playerPlacedName;
            {
                this.this$0 = $receiver;
                this.$playerPlacedName = $playerPlacedName;
                super(1);
            }

            public final void invoke(@NotNull Position position) {
                Intrinsics.checkNotNullParameter(position, "position");
                if (!BoardGraphicalUi.access$isDrawing$p(this.this$0)) {
                    Game game = BoardGraphicalUi.access$getGame$p(this.this$0);
                    if (game == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("game");
                        game = null;
                    }
                    if (GameService.INSTANCE.winner(game) == null) {
                        BoardGraphicalUi.access$playOnClick(this.this$0, position, this.$playerPlacedName);
                    }
                }
            }
        });
        JFrame jFrame = this.frame;
        if (jFrame == null) {
            Intrinsics.throwUninitializedPropertyAccessException("frame");
            jFrame = null;
        }
        jFrame.add(GuiConstantsKt.getBIG_HORIZONTAL_DISTANCE(), "West");
        JFrame jFrame2 = this.frame;
        if (jFrame2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("frame");
            jFrame2 = null;
        }
        if ((boardCanvas = this.boardCanvas) == null) {
            Intrinsics.throwUninitializedPropertyAccessException("boardCanvas");
            boardCanvas = null;
        }
        jFrame2.add((Component)boardCanvas, "Center");
        JFrame jFrame3 = this.frame;
        if (jFrame3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("frame");
            jFrame3 = null;
        }
        jFrame3.add(GuiConstantsKt.getSMALL_HORIZONTAL_DISTANCE(), "East");
    }

    private final void addTitelToFrame() {
        JLabel title = new JLabel("Chain Reaction", 0);
        title.setFont(new Font("Arial", 0, 50));
        title.setForeground(Color.BLACK);
        JFrame jFrame = this.frame;
        if (jFrame == null) {
            Intrinsics.throwUninitializedPropertyAccessException("frame");
            jFrame = null;
        }
        jFrame.add((Component)title, "North");
    }

    /*
     * WARNING - void declaration
     */
    public final void onFigureChanged(@NotNull GameEvent gameEvent) {
        Intrinsics.checkNotNullParameter(gameEvent, "gameEvent");
        GameEvent gameEvent2 = gameEvent;
        if (gameEvent2 instanceof BombsToUpdate) {
            this.isDrawing = true;
            Iterable $this$forEach$iv = ((BombsToUpdate)gameEvent).getBombsToUpdate();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BombToUpdate it = (BombToUpdate)element$iv;
                boolean bl = false;
                Game game = this.game;
                if (game == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("game");
                    game = null;
                }
                game.getBoard().setFigure(it.getPosition(), BombFactory.INSTANCE.createBomb(it.getPlayer(), it.getLevel()));
                BoardCanvas boardCanvas = this.boardCanvas;
                if (boardCanvas == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("boardCanvas");
                    boardCanvas = null;
                }
                boardCanvas.onFigureChanged(it, (Function1<? super Board, Unit>)new Function1<Board, Unit>(gameEvent, this){
                    final /* synthetic */ GameEvent $gameEvent;
                    final /* synthetic */ BoardGraphicalUi this$0;
                    {
                        this.$gameEvent = $gameEvent;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Board board) {
                        block0: {
                            Intrinsics.checkNotNullParameter(board, "board");
                            Player player = ((BombsToUpdate)this.$gameEvent).getCurrentPlayer();
                            if (player == null) break block0;
                            Player player2 = player;
                            BoardGraphicalUi boardGraphicalUi = this.this$0;
                            Player currentPlayer = player2;
                            boolean bl = false;
                            BoardGraphicalUi.access$updateInfoText(boardGraphicalUi, board, currentPlayer.getName());
                        }
                    }
                });
            }
            this.isDrawing = false;
            DelayerService.INSTANCE.reset();
        } else if (gameEvent2 instanceof GameFinish) {
            String string = ((GameFinish)gameEvent).getWinnerName();
            Color color = GuiConstantsKt.toColor(((GameFinish)gameEvent).getWinnerColor());
            JFrame jFrame = this.frame;
            if (jFrame == null) {
                Intrinsics.throwUninitializedPropertyAccessException("frame");
                jFrame = null;
            }
            new EndDialog(string, color, jFrame);
        } else if (gameEvent2 instanceof Init) {
            String nameOfSender = this.isMain ? "local" : "";
            this.init(((Init)gameEvent).getDimension(), ((Init)gameEvent).getWalls(), ((Init)gameEvent).getPlayers(), nameOfSender);
        } else if (gameEvent2 instanceof PlayerDisconnect) {
            Game game;
            void $this$flatMapTo$iv$iv;
            Game game2 = this.game;
            if (game2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("game");
                game2 = null;
            }
            Iterable $this$flatMap$iv = RangesKt.until(0, game2.getBoard().getDimension().getY());
            boolean $i$f$flatMap = false;
            Iterable element$iv = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            Iterator iterator2 = $this$flatMapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void $this$mapNotNullTo$iv$iv;
                int element$iv$iv;
                int positionY = element$iv$iv = ((IntIterator)iterator2).nextInt();
                boolean bl = false;
                Game game3 = this.game;
                if (game3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("game");
                    game3 = null;
                }
                Iterable $this$mapNotNull$iv = RangesKt.until(0, game3.getBoard().getDimension().getX());
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
                while (iterator3.hasNext()) {
                    Position position;
                    Figure figure;
                    Object object;
                    int element$iv$iv$iv;
                    int element$iv$iv2 = element$iv$iv$iv = ((IntIterator)iterator3).nextInt();
                    boolean bl2 = false;
                    int positionX = element$iv$iv2;
                    boolean bl3 = false;
                    Position position2 = new Position(positionX, positionY);
                    Game game4 = this.game;
                    if (game4 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("game");
                        game4 = null;
                    }
                    if (Intrinsics.areEqual((object = (figure = game4.getBoard().getFigure(position2))) != null && (object = object.getPlayer()) != null ? ((Player)object).getName() : null, ((PlayerDisconnect)gameEvent).getPlayerToLeave())) {
                        Game game5 = this.game;
                        if (game5 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("game");
                            game5 = null;
                        }
                        game5.getBoard().setFigure(position2, EmptyFigure.INSTANCE);
                        position = position2;
                    } else {
                        position = null;
                    }
                    if (position == null) continue;
                    Position it$iv$iv = position;
                    boolean bl4 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            List allChanged = (List)destination$iv$iv;
            BoardCanvas boardCanvas = this.boardCanvas;
            if (boardCanvas == null) {
                Intrinsics.throwUninitializedPropertyAccessException("boardCanvas");
                boardCanvas = null;
            }
            if ((game = this.game) == null) {
                Intrinsics.throwUninitializedPropertyAccessException("game");
                game = null;
            }
            boardCanvas.paintAllFigures(game.getBoard());
            this.painLeftPlayerCounterGray(((PlayerDisconnect)gameEvent).getPlayerToLeave());
            Function1<? super GameEvent, Unit> function1 = this.playOnClick;
            if (function1 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("playOnClick");
                function1 = null;
            }
            Player player = ((PlayerDisconnect)gameEvent).getCurrentPlayer();
            function1.invoke(new AfterDisconnect(((PlayerDisconnect)gameEvent).getPlayerToLeave(), Intrinsics.areEqual(((PlayerDisconnect)gameEvent).getPlayerToLeave(), player != null ? player.getName() : null), allChanged));
        }
    }

    public final void painLeftPlayerCounterGray(@NotNull String playerName) {
        Object v2;
        block3: {
            Intrinsics.checkNotNullParameter(playerName, "playerName");
            List<? extends JLabel> list = this.countLabels;
            if (list == null) {
                Intrinsics.throwUninitializedPropertyAccessException("countLabels");
                list = null;
            }
            Iterable iterable = list;
            for (Object t : iterable) {
                JLabel it = (JLabel)t;
                boolean bl = false;
                String string = it.getText();
                Intrinsics.checkNotNullExpressionValue(string, "it.text");
                if (!StringsKt.contains$default((CharSequence)string, ' ' + playerName + ':', false, 2, null)) continue;
                v2 = t;
                break block3;
            }
            v2 = null;
        }
        JLabel jLabel = v2;
        if (jLabel != null) {
            jLabel.setForeground(Color.lightGray);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateInfoText(Board board, String currentName) {
        void $this$mapIndexedTo$iv$iv;
        int $i$f$count;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Game game = this.game;
        if (game == null) {
            Intrinsics.throwUninitializedPropertyAccessException("game");
            game = null;
        }
        Iterable $this$map$iv = CollectionsKt.getIndices((Collection)game.getPlayers());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            int n;
            int item$iv$iv;
            int n2 = item$iv$iv = ((IntIterator)iterator2).nextInt();
            collection = destination$iv$iv;
            boolean bl = false;
            Iterable $this$count$iv = board.getDimension().getAllPositions();
            $i$f$count = 0;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    void playerIndex;
                    Position pos = (Position)element$iv;
                    boolean bl2 = false;
                    Game game2 = this.game;
                    if (game2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("game");
                        game2 = null;
                    }
                    if (!(board.getBombsPlayerIndex(pos, game2.getPlayers()) == playerIndex) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            collection.add(n);
        }
        List counters = (List)destination$iv$iv;
        Iterable $this$mapIndexed$iv = counters;
        boolean $i$f$mapIndexed = false;
        $this$mapTo$iv$iv = $this$mapIndexed$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void value;
            void index;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int $this$count$iv = ((Number)item$iv$iv).intValue();
            $i$f$count = n;
            collection = destination$iv$iv;
            boolean bl = false;
            List<? extends JLabel> list = this.countLabels;
            if (list == null) {
                Intrinsics.throwUninitializedPropertyAccessException("countLabels");
                list = null;
            }
            StringBuilder stringBuilder = new StringBuilder().append("Bomb counter ");
            Game game3 = this.game;
            if (game3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("game");
                game3 = null;
            }
            list.get((int)index).setText(stringBuilder.append(game3.getPlayers().get((int)index).getName()).append(": ").append((int)value).toString());
            collection.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        this.currentPlayerLabel.setText("The Current Player is: " + currentName);
    }

    /*
     * WARNING - void declaration
     */
    private final void createInfoText(JPanel textPanel) {
        void $this$mapIndexedTo$iv$iv;
        List<? extends JLabel> list = this.countLabels;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException("countLabels");
            list = null;
        }
        Iterable $this$mapIndexed$iv = list;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void label;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            JLabel jLabel = (JLabel)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            label.setFont(GuiConstantsKt.getLABEL_FONT());
            label.setBackground(GuiConstantsKt.getLABEL_BACKGROUND());
            PlayerColor playerColor = PlayerColor.Companion.forIndex((int)index);
            label.setForeground(playerColor != null ? GuiConstantsKt.toForegroundColor(playerColor) : null);
            collection.add(textPanel.add((Component)label));
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        textPanel.setBackground(Color.WHITE);
        Game game = this.game;
        if (game == null) {
            Intrinsics.throwUninitializedPropertyAccessException("game");
            game = null;
        }
        Player player = game.getCurrent();
        String initialPlayerName = player != null ? player.getName() : null;
        this.currentPlayerLabel.setText("The first Player is: " + initialPlayerName);
        this.currentPlayerLabel.setFont(GuiConstantsKt.getLABEL_FONT());
        this.currentPlayerLabel.setBackground(GuiConstantsKt.getLABEL_BACKGROUND());
        textPanel.add(this.currentPlayerLabel);
    }

    public static final /* synthetic */ boolean access$isDrawing$p(BoardGraphicalUi $this) {
        return $this.isDrawing;
    }

    public static final /* synthetic */ Game access$getGame$p(BoardGraphicalUi $this) {
        return $this.game;
    }

    public static final /* synthetic */ void access$playOnClick(BoardGraphicalUi $this, Position position, String playerPlacedName) {
        $this.playOnClick(position, playerPlacedName);
    }

    public static final /* synthetic */ void access$updateInfoText(BoardGraphicalUi $this, Board board, String currentName) {
        $this.updateInfoText(board, currentName);
    }
}

