/*
 * Decompiled with CFR 0.152.
 */
package service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import model.board.Game;
import model.board.Position;
import model.player.Bot;
import model.player.Human;
import model.player.NetWork;
import model.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import server.BombsToUpdate;
import server.GameEvent;
import service.BoardService;
import service.GameService;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\n"}, d2={"Lservice/GameProgressService;", "", "()V", "playOnClick", "Lserver/GameEvent;", "game", "Lmodel/board/Game;", "position", "Lmodel/board/Position;", "start", "chain-reaction"})
@SourceDebugExtension(value={"SMAP\nGameProgressService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GameProgressService.kt\nservice/GameProgressService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,36:1\n1#2:37\n*E\n"})
public final class GameProgressService {
    @NotNull
    public static final GameProgressService INSTANCE = new GameProgressService();

    private GameProgressService() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final GameEvent start(@NotNull Game game) {
        Object t;
        Player it;
        Intrinsics.checkNotNullParameter(game, "game");
        if (!(game.getPlayers().get(0) instanceof Bot)) return null;
        Iterable iterable = game.getPlayers();
        Iterator iterator2 = iterable.iterator();
        do {
            if (!iterator2.hasNext()) return null;
            t = iterator2.next();
            it = (Player)t;
            boolean bl = false;
        } while (!(it instanceof Human || it instanceof NetWork));
        Object v0 = t;
        if (v0 == null) return null;
        GameEvent gameEvent = this.playOnClick(game, BoardService.INSTANCE.getRandomValidNextPosition(game));
        return gameEvent;
    }

    @NotNull
    public final GameEvent playOnClick(@NotNull Game game, @NotNull Position position) {
        Intrinsics.checkNotNullParameter(game, "game");
        Intrinsics.checkNotNullParameter(position, "position");
        List bombToUpdateList = new ArrayList();
        if (BoardService.INSTANCE.isValidForNextAction(game, position)) {
            CollectionsKt.addAll((Collection)bombToUpdateList, (Iterable)GameService.INSTANCE.handlePlaceBombAndExplosions(game, position));
            GameService.INSTANCE.startNextRound(game);
        }
        return new BombsToUpdate(bombToUpdateList, game.getCurrent());
    }
}

