/*
 * Decompiled with CFR 0.152.
 */
package service;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import model.board.Board;
import model.board.BoardInitializeData;
import model.board.Dimension;
import model.board.Game;
import model.figure.Wall;
import model.player.Player;
import org.jetbrains.annotations.NotNull;
import service.BoardFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J*\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\n\u00a8\u0006\u000e"}, d2={"Lservice/GameFactory;", "", "()V", "create", "Lmodel/board/Game;", "boardInitializeData", "Lmodel/board/BoardInitializeData;", "dimension", "Lmodel/board/Dimension;", "walls", "", "Lmodel/figure/Wall;", "players", "Lmodel/player/Player;", "chain-reaction"})
public final class GameFactory {
    @NotNull
    public static final GameFactory INSTANCE = new GameFactory();

    private GameFactory() {
    }

    @NotNull
    public final Game create(@NotNull BoardInitializeData boardInitializeData) {
        Intrinsics.checkNotNullParameter(boardInitializeData, "boardInitializeData");
        Board board = BoardFactory.INSTANCE.create(boardInitializeData.getDimension(), boardInitializeData.getWalls());
        return new Game(boardInitializeData.getPlayers(), board, 0, 4, null);
    }

    @NotNull
    public final Game create(@NotNull Dimension dimension, @NotNull List<Wall> walls, @NotNull List<? extends Player> players2) {
        Intrinsics.checkNotNullParameter(dimension, "dimension");
        Intrinsics.checkNotNullParameter(walls, "walls");
        Intrinsics.checkNotNullParameter(players2, "players");
        Board board = BoardFactory.INSTANCE.create(dimension, walls);
        return new Game(players2, board, 0, 4, null);
    }
}

