/*
 * Decompiled with CFR 0.152.
 */
package service;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import model.board.Board;
import model.board.Position;
import model.figure.Bomb;
import model.figure.EmptyFigure;
import model.figure.Figure;
import model.figure.Wall;
import model.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import service.BombFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lservice/BombService;", "", "()V", "updateBomb", "Lmodel/figure/Bomb;", "currentPlayer", "Lmodel/player/Player;", "board", "Lmodel/board/Board;", "position", "Lmodel/board/Position;", "chain-reaction"})
public final class BombService {
    @NotNull
    public static final BombService INSTANCE = new BombService();

    private BombService() {
    }

    @Nullable
    public final Bomb updateBomb(@NotNull Player currentPlayer, @NotNull Board board, @NotNull Position position) {
        Bomb bomb;
        Intrinsics.checkNotNullParameter(currentPlayer, "currentPlayer");
        Intrinsics.checkNotNullParameter(board, "board");
        Intrinsics.checkNotNullParameter(position, "position");
        Figure figure = board.getFigure(position);
        if (figure instanceof EmptyFigure) {
            bomb = BombFactory.INSTANCE.createBomb(currentPlayer, position, board.getDimension());
        } else if (figure instanceof Bomb) {
            int newLevel = ((Bomb)figure).getLevel();
            newLevel = board.getDimension().isBorder(position) && newLevel > 1 ? (newLevel -= 2) : --newLevel;
            bomb = BombFactory.INSTANCE.createBomb(currentPlayer, newLevel);
        } else if (figure instanceof Wall) {
            bomb = null;
        } else if (figure == null) {
            bomb = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bomb;
    }
}

