/*
 * Decompiled with CFR 0.152.
 */
package service;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import model.board.Dimension;
import model.board.Position;
import model.figure.Bomb;
import model.player.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u000e"}, d2={"Lservice/BombFactory;", "", "()V", "createBomb", "Lmodel/figure/Bomb;", "player", "Lmodel/player/Player;", "level", "", "position", "Lmodel/board/Position;", "dimension", "Lmodel/board/Dimension;", "initLevel", "chain-reaction"})
public final class BombFactory {
    @NotNull
    public static final BombFactory INSTANCE = new BombFactory();

    private BombFactory() {
    }

    @NotNull
    public final Bomb createBomb(@NotNull Player player, @NotNull Position position, @NotNull Dimension dimension) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(position, "position");
        Intrinsics.checkNotNullParameter(dimension, "dimension");
        int initLevel = this.initLevel(position, dimension);
        return new Bomb(player, initLevel);
    }

    @NotNull
    public final Bomb createBomb(@NotNull Player player, int level) {
        Intrinsics.checkNotNullParameter(player, "player");
        return new Bomb(player, level);
    }

    private final int initLevel(Position position, Dimension dimension) {
        return dimension.isCorner(position) ? 1 : 3;
    }
}

