/*
 * Decompiled with CFR 0.152.
 */
package service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import model.board.Board;
import model.board.Game;
import model.board.Position;
import model.figure.Bomb;
import model.figure.Figure;
import model.figure.Wall;
import model.player.Player;
import org.jetbrains.annotations.NotNull;
import service.BoardExtensionsKt;
import service.GameService;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\n\u00a8\u0006\u0013"}, d2={"Lservice/BoardService;", "", "()V", "countBombs", "", "Lmodel/player/Player;", "", "board", "Lmodel/board/Board;", "getRandomValidNextPosition", "Lmodel/board/Position;", "game", "Lmodel/board/Game;", "getWalls", "", "Lmodel/figure/Wall;", "isValidForNextAction", "", "position", "chain-reaction"})
@SourceDebugExtension(value={"SMAP\nBoardService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BoardService.kt\nservice/BoardService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,44:1\n1549#2:45\n1620#2,3:46\n800#2,11:49\n1477#2:60\n1502#2,3:61\n1505#2,3:71\n1238#2,4:76\n1603#2,9:80\n1855#2:89\n1856#2:91\n1612#2:92\n361#3,7:64\n442#3:74\n392#3:75\n1#4:90\n*S KotlinDebug\n*F\n+ 1 BoardService.kt\nservice/BoardService\n*L\n13#1:45\n13#1:46,3\n14#1:49,11\n15#1:60\n15#1:61,3\n15#1:71,3\n16#1:76,4\n34#1:80,9\n34#1:89\n34#1:91\n34#1:92\n15#1:64,7\n16#1:74\n16#1:75\n34#1:90\n*E\n"})
public final class BoardService {
    @NotNull
    public static final BoardService INSTANCE = new BoardService();

    private BoardService() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<Player, Integer> countBombs(@NotNull Board board) {
        void $this$mapValuesTo$iv$iv;
        Object value$iv$iv$iv;
        Object key$iv$iv;
        Object $this$groupByTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Object object;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(board, "board");
        Iterable $this$map$iv = board.getDimension().getAllPositions();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Position position = (Position)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(board.getFigure((Position)it));
        }
        Iterable $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$filterIsInstance = false;
        $this$mapTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof Bomb)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$groupBy$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$filterIsInstanceTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator iterator2 = $this$groupByTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object object2;
            Object element$iv$iv;
            element$iv$iv = iterator2.next();
            Bomb figure = (Bomb)element$iv$iv;
            boolean bl = false;
            key$iv$iv = figure.getPlayer();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        Object $this$mapValues$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            key$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object object3 = destination$iv$iv;
            boolean bl = false;
            value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            object = object3;
            boolean bl3 = false;
            Integer n = ((List)it.getValue()).size();
            object.put(k, n);
        }
        return destination$iv$iv;
    }

    @NotNull
    public final Position getRandomValidNextPosition(@NotNull Game game) {
        Intrinsics.checkNotNullParameter(game, "game");
        Position position = null;
        while (!this.isValidForNextAction(game, position = game.getBoard().getDimension().getRandomPosition())) {
        }
        return position;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isValidForNextAction(@NotNull Game game, @NotNull Position position) {
        Intrinsics.checkNotNullParameter(game, "game");
        Intrinsics.checkNotNullParameter(position, "position");
        if (!BoardExtensionsKt.isEmpty(game.getBoard(), position)) {
            Player player = game.getCurrent();
            if (player == null) return false;
            Player it = player;
            boolean bl = false;
            if (!game.getBoard().isBombFromPlayer(position, it)) return false;
            boolean bl2 = true;
            if (!bl2) return false;
        }
        if (GameService.INSTANCE.winner(game) != null) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Wall> getWalls(@NotNull Board board) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(board, "board");
        Iterable $this$mapNotNull$iv = new IntRange(0, board.getDimension().getX() * board.getDimension().getY());
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Wall wall;
            int y;
            int element$iv$iv$iv;
            int element$iv$iv = element$iv$iv$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            int it = element$iv$iv;
            boolean bl2 = false;
            int x = it % board.getDimension().getX();
            Position position = new Position(x, y = it / board.getDimension().getX());
            if (BoardExtensionsKt.isWall(board, position)) {
                Figure figure = board.getFigure(position);
                Intrinsics.checkNotNull(figure, "null cannot be cast to non-null type model.figure.Wall");
                wall = (Wall)figure;
            } else {
                wall = null;
            }
            if (wall == null) continue;
            Wall it$iv$iv = wall;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

